/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.ropebridge.item;

import com.mcmoddev.ropebridge.RopeBridge;
import com.mcmoddev.ropebridge.block.BridgeSlab;
import com.mcmoddev.ropebridge.handler.ContentHandler;
import com.mcmoddev.ropebridge.item.ItemBuilder;
import com.mcmoddev.ropebridge.lib.ModUtils;
import com.mcmoddev.ropebridge.network.BridgeMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBridgeBuilder
extends ItemBuilder {
    public ItemBridgeBuilder() {
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        super.onUsingTick(stack, player, count);
        if (player.field_70170_p.field_72995_K && player instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)player;
            ItemBridgeBuilder.rotatePlayerTowards(p, ItemBridgeBuilder.getNearestYaw(p));
        }
    }

    private static void rotatePlayerTowards(EntityPlayer player, float target) {
        float yaw = player.field_70177_z % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        ItemBridgeBuilder.rotatePlayerTo(player, yaw + (target - yaw) / 4.0f);
    }

    private static void rotatePlayerTo(EntityPlayer player, float yaw) {
        float original = player.field_70177_z;
        player.field_70177_z = yaw;
        player.field_70126_B += player.field_70177_z - original;
    }

    private static float getNearestYaw(EntityPlayer player) {
        float yaw = player.field_70177_z % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw < 45.0f) {
            return 0.0f;
        }
        if (yaw > 45.0f && yaw <= 135.0f) {
            return 90.0f;
        }
        if (yaw > 135.0f && yaw <= 225.0f) {
            return 180.0f;
        }
        if (yaw > 225.0f && yaw <= 315.0f) {
            return 270.0f;
        }
        return 360.0f;
    }

    @Override
    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer && world.field_72995_K) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (this.func_77626_a(stack) - timeLeft > 10) {
                if (!player.field_70122_E) {
                    ModUtils.tellPlayer((ICommandSender)player, "chat.ropebridge.info.notonground", new Object[0]);
                } else {
                    RayTraceResult hit = ItemBridgeBuilder.trace(player);
                    if (hit.field_72313_a == RayTraceResult.Type.BLOCK) {
                        BlockPos floored = new BlockPos(Math.floor(player.field_70165_t), Math.floor(player.field_70163_u) - 1.0, Math.floor(player.field_70161_v)).func_177977_b();
                        BlockPos target = hit.func_178782_a();
                        RopeBridge.getSnw().sendToServer((IMessage)new BridgeMessage(floored, target));
                    }
                }
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        IBlockState state = player.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!player.field_70170_p.field_72995_K && player.func_70093_af() && ItemBridgeBuilder.isBridgeBlock(player.field_70170_p.func_180495_p(pos).func_177230_c())) {
            ModUtils.tellPlayer((ICommandSender)RopeBridge.getProxy().getPlayer(), "chat.ropebridge.warning.breaking", new Object[0]);
            ItemBridgeBuilder.breakBridge(player, player.field_70170_p, pos, block.func_176201_c(state));
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (FMLCommonHandler.instance().getSide().isClient() && RopeBridge.getProxy().getPlayer().func_70093_af() && ItemBridgeBuilder.isBridgeBlock(state.func_177230_c())) {
            return 0.3f;
        }
        return super.func_150893_a(stack, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("- Hold right-click to build");
        tooltip.add("- Sneak to break whole bridge");
    }

    private static boolean isBridgeBlock(Block blockIn) {
        return blockIn == ContentHandler.blockBridgeSlab1 || blockIn == ContentHandler.blockBridgeSlab2 || blockIn == ContentHandler.blockBridgeSlab3 || blockIn == ContentHandler.blockBridgeSlab4;
    }

    private static void breakBridge(EntityPlayer player, World worldIn, BlockPos posIn, int meta) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
            int xRange = 0;
            int zRange = 0;
            if (meta % 2 == 0) {
                xRange = 1;
            } else {
                zRange = 1;
            }
            LinkedList<BlockPos> newQueue = new LinkedList<BlockPos>();
            newQueue.add(posIn);
            LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
            queue.add(posIn);
            while (!newQueue.isEmpty()) {
                BlockPos pos = (BlockPos)newQueue.remove();
                for (int x = pos.func_177958_n() - xRange; x <= pos.func_177958_n() + xRange; ++x) {
                    for (int y = pos.func_177956_o() - 1; y <= pos.func_177956_o() + 1; ++y) {
                        for (int z = pos.func_177952_p() - zRange; z <= pos.func_177952_p() + zRange; ++z) {
                            IBlockState currentBlockState;
                            BlockPos currentPos = new BlockPos(x, y, z);
                            if (x - pos.func_177958_n() == 0 && z - pos.func_177952_p() == 0 || queue.contains(currentPos) || !ItemBridgeBuilder.isBridgeBlock((currentBlockState = worldIn.func_180495_p(currentPos)).func_177230_c()) || currentBlockState.func_177230_c().func_176201_c(currentBlockState) != meta) continue;
                            newQueue.add(currentPos);
                        }
                    }
                }
                queue.add(pos);
            }
            Timer timer = new Timer();
            BreakTask task = new BreakTask(queue, worldIn, timer, !player.field_71075_bZ.field_75098_d);
            timer.schedule((TimerTask)task, 100L, 100L);
        });
    }

    private static class BreakTask
    extends TimerTask {
        private final Queue<BlockPos> queue;
        private final World world;
        private final Timer timer;
        private final boolean drop;

        public BreakTask(Queue<BlockPos> queue, World world, Timer timer, boolean drop) {
            this.queue = queue;
            this.world = world;
            this.timer = timer;
            this.drop = drop;
        }

        @Override
        public void run() {
            BlockPos pos = this.queue.remove();
            if (this.world.func_180495_p(pos).func_177230_c() instanceof BridgeSlab) {
                FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> this.world.func_175655_b(pos, this.drop));
            }
            if (this.queue.isEmpty()) {
                this.timer.cancel();
            }
        }
    }
}

