/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.ropebridge.lib;

import com.mcmoddev.ropebridge.handler.ContentHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModUtils {
    protected static final List<Item> ITEMS = new ArrayList<Item>();
    protected static final List<Block> BLOCKS = new ArrayList<Block>();

    public static void tellPlayer(ICommandSender sender, String message, Object ... params) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(message, params));
    }

    public static Block registerBlockNoItem(Block block, String id) {
        block.setRegistryName(id);
        block.func_149663_c("ropebridge." + id.toLowerCase().replace("_", "."));
        GameData.register_impl((IForgeRegistryEntry)block);
        BLOCKS.add(block);
        return block;
    }

    public static Item registerItem(Item item, String id) {
        if (item.getRegistryName() == null) {
            item.setRegistryName(id);
        }
        item.func_77637_a(ContentHandler.RopeBridgeTab);
        item.func_77655_b("ropebridge." + id.toLowerCase().replace("_", "."));
        GameData.register_impl((IForgeRegistryEntry)item);
        ITEMS.add(item);
        return item;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockInvModel(Block block, String[] variants) {
        ModUtils.registerItemInvModel(Item.func_150898_a((Block)block), variants);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockInvModel(Block block, String prefix, String[] variants) {
        ModUtils.registerItemInvModel(Item.func_150898_a((Block)block), prefix, variants);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockInvModel(Block block) {
        ModUtils.registerItemInvModel(Item.func_150898_a((Block)block), 0);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockInvModel(Block block, int meta) {
        ModUtils.registerItemInvModel(Item.func_150898_a((Block)block), meta);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemInvModel(Item item, int meta, String model) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(model, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemInvModel(Item item, String prefix, String[] variants) {
        for (int meta = 0; meta < variants.length; ++meta) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().func_110624_b() + ":" + prefix + "_" + variants[meta], "inventory"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemInvModel(Item item, String[] variants) {
        for (int meta = 0; meta < variants.length; ++meta) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().func_110624_b() + ":" + variants[meta], "inventory"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemInvModel(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemInvModel(Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), "inventory"));
    }
}

