/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils;

import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.Config;

public class ModifierHandler {
    public static final UUID MODIFIER_ID_HEALTH = UUID.fromString("c0bef565-35f6-4dc5-bb4c-3644c382e6ce");
    public static final UUID MODIFIER_ID_DAMAGE = UUID.fromString("d3560b15-c459-451c-86a8-0247015ae899");
    public static final String MODIFIER_NAME_HEALTH = "ScalingHealth.HealthModifier";
    public static final String MODIFIER_NAME_DAMAGE = "ScalingHealth.DamageModifier";

    private static void setModifier(IAttributeInstance attr, UUID id, String name, double amount, int op) {
        if (attr == null) {
            return;
        }
        double normalValue = attr.func_111125_b();
        double difference = amount - normalValue;
        AttributeModifier mod = attr.func_111127_a(id);
        AttributeModifier newMod = new AttributeModifier(id, name, difference, op);
        if (mod != null) {
            attr.func_111124_b(mod);
        }
        attr.func_111121_a(newMod);
    }

    public static void setMaxHealth(EntityLivingBase entity, double amount, int op) {
        if (amount <= 0.0) {
            ScalingHealth.logHelper.warn("ModifierHandler.setMaxHealth: amount <= 0!", new Object[0]);
            return;
        }
        if (entity instanceof EntityPlayer && !Config.Player.Health.allowModify) {
            ScalingHealth.logHelper.info(String.format("Would have set player %s's health to %.1f, but modified player health has been disabled in the config!", entity.func_70005_c_(), amount), new Object[0]);
            return;
        }
        float originalHealth = entity.func_110143_aJ();
        IAttributeInstance attr = entity.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (attr != null) {
            ModifierHandler.setModifier(attr, MODIFIER_ID_HEALTH, MODIFIER_NAME_HEALTH, amount, op);
            entity.func_70606_j(originalHealth);
        }
    }

    public static void addAttackDamage(EntityLivingBase entity, double amount, int op) {
        IAttributeInstance attr = entity.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (attr != null) {
            ModifierHandler.setModifier(attr, MODIFIER_ID_DAMAGE, MODIFIER_NAME_DAMAGE, amount += attr.func_111125_b(), op);
        }
    }

    public static double getHealthModifier(EntityLivingBase entity) {
        IAttributeInstance attr = entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        if (attr == null) {
            return 0.0;
        }
        AttributeModifier mod = attr.func_111127_a(MODIFIER_ID_HEALTH);
        return mod != null ? mod.func_111164_d() : 0.0;
    }

    public static double getDamageModifier(EntityLivingBase entity) {
        IAttributeInstance attr = entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e);
        if (attr == null) {
            return 0.0;
        }
        AttributeModifier mod = attr.func_111127_a(MODIFIER_ID_DAMAGE);
        return mod != null ? mod.func_111164_d() : 0.0;
    }
}

