/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.silentchaos512.lib.registry.SRegistry;

public interface IEnumItems<E extends Enum<E>, I extends Item>
extends IStringSerializable {
    @Nonnull
    public E getEnum();

    @Nonnull
    public I getItem();

    @Nonnull
    default public ItemStack getStack() {
        return new ItemStack(this.getItem());
    }

    @Nonnull
    default public ItemStack getStack(int amount) {
        return new ItemStack(this.getItem(), amount);
    }

    @Nonnull
    default public String func_176610_l() {
        String prefix = this.getNamePrefix();
        return (!prefix.isEmpty() ? prefix + "_" : "") + ((Enum)this.getEnum()).name().toLowerCase(Locale.ROOT);
    }

    @Nonnull
    default public String getNamePrefix() {
        return "";
    }

    @Deprecated
    public static void registerItems(IEnumItems[] array, SRegistry registry) {
        IEnumItems.registerItems(Arrays.asList(array), registry);
    }

    @Deprecated
    public static void registerItems(Collection<? extends IEnumItems> list, SRegistry registry) {
        list.forEach(e -> registry.registerItem(e.getItem(), e.func_176610_l()));
    }

    public static class RegistrationHelper {
        private final SRegistry registry;

        public RegistrationHelper(SRegistry registry) {
            this.registry = registry;
        }

        public void registerItems(IEnumItems ... items) {
            for (IEnumItems item : items) {
                this.registry.registerItem(item.getItem(), item.func_176610_l());
            }
        }

        public <E extends Enum<E>> void registerBlocksGenericEnum(Function<E, Block> block, Function<E, String> name, Class<E> enumClass) {
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                this.registry.registerBlock(block.apply(e), name.apply(e));
            }
        }

        public <E extends Enum<E>> void registerItemsGenericEnum(Function<E, Item> item, Function<E, String> name, Class<E> enumClass) {
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                this.registry.registerItem(item.apply(e), name.apply(e));
            }
        }
    }
}

