/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import soot.IProxy;
import soot.Registry;
import soot.block.IBlockVariants;
import soot.entity.EntityCustomCloud;
import soot.entity.EntityMuse;
import soot.entity.EntityMuseRenderer;
import soot.tile.TileEntityAlchemyGlobe;
import soot.tile.TileEntityAlchemyGlobeRenderer;
import soot.tile.TileEntityDecanterTop;
import soot.tile.TileEntityDecanterTopRenderer;
import soot.tile.TileEntityEmberBurst;
import soot.tile.TileEntityEmberBurstRenderer;
import soot.tile.TileEntityRedstoneBin;
import soot.tile.TileEntityStillTip;
import soot.tile.TileEntityStillTipRenderer;
import soot.util.IBlockColored;
import soot.util.IItemColored;
import soot.util.ResourceProxy;
import teamroots.embers.tileentity.TileEntityBinRenderer;

public class ClientProxy
implements IProxy {
    ArrayList<IBlockColored> COLOR_BLOCKS = new ArrayList();
    ArrayList<IItemColored> COLOR_ITEMS = new ArrayList();
    static ResourceProxy resourceProxy = new ResourceProxy();

    @Override
    public void registerResourcePack() {
        List packs = (List)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String)"field_110449_ao");
        packs.add(resourceProxy);
    }

    @Override
    public EntityPlayer getMainPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void addResourceOverride(String space, String dir, String file, String ext) {
        resourceProxy.addResource(space, dir, file, ext);
    }

    @Override
    public void addResourceOverride(String modid, String space, String dir, String file, String ext) {
        resourceProxy.addResource(space, modid, dir, file, ext);
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void registerItemModel(Block block) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        Registry.registerBlockModels();
        Registry.registerItemModels();
        RenderingRegistry.registerEntityRenderingHandler(EntityCustomCloud.class, manager -> new Render<EntityCustomCloud>(manager){

            @Nullable
            protected ResourceLocation getEntityTexture(EntityCustomCloud entity) {
                return null;
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityMuse.class, EntityMuseRenderer::new);
    }

    @Override
    public void init() {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        for (IBlockColored block : this.COLOR_BLOCKS) {
            blockColors.func_186722_a(block::getColorMultiplier, new Block[]{(Block)block});
        }
        for (IItemColored item : this.COLOR_ITEMS) {
            itemColors.func_186730_a(item::getColorFromItemstack, new Item[]{(Item)item});
        }
        ClientProxy.registerTESRs();
    }

    @Override
    public void postInit() {
    }

    public static void registerTESRs() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEmberBurst.class, (TileEntitySpecialRenderer)new TileEntityEmberBurstRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAlchemyGlobe.class, (TileEntitySpecialRenderer)new TileEntityAlchemyGlobeRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRedstoneBin.class, (TileEntitySpecialRenderer)new TileEntityBinRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityStillTip.class, (TileEntitySpecialRenderer)new TileEntityStillTipRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDecanterTop.class, (TileEntitySpecialRenderer)new TileEntityDecanterTopRenderer());
    }

    @Override
    public void registerBlockModel(Block block) {
        if (block instanceof IBlockColored) {
            this.COLOR_BLOCKS.add((IBlockColored)block);
        }
    }

    @Override
    public void registerItemModel(Item item) {
        if (item instanceof IItemColored) {
            this.COLOR_ITEMS.add((IItemColored)item);
        }
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.func_179223_d();
            ResourceLocation resloc = block.getRegistryName();
            if (block instanceof IBlockVariants) {
                for (IBlockState state : ((IBlockVariants)block).getValidStates()) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(resloc, ((IBlockVariants)block).getBlockStateName(state)));
                }
            } else {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(resloc, "inventory"));
            }
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }
}

