/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import soot.Config;
import soot.Soot;
import soot.block.BlockAlchemyGauge;
import soot.block.BlockAlchemyGlobe;
import soot.block.BlockDecanter;
import soot.block.BlockDistillationPipe;
import soot.block.BlockEmberBurst;
import soot.block.BlockInsulation;
import soot.block.BlockModSlab;
import soot.block.BlockModStairs;
import soot.block.BlockPillar;
import soot.block.BlockRedstoneBin;
import soot.block.BlockScale;
import soot.block.BlockStill;
import soot.block.BlockSulfurOre;
import soot.block.overrides.BlockAlchemyPedestalImproved;
import soot.block.overrides.BlockAlchemyTabletImproved;
import soot.block.overrides.BlockBeamCannonImproved;
import soot.block.overrides.BlockCrystalCellImproved;
import soot.block.overrides.BlockDawnstoneAnvilImproved;
import soot.block.overrides.BlockEmberBoreImproved;
import soot.block.overrides.BlockHeatCoilImproved;
import soot.block.overrides.BlockMechAccessorImproved;
import soot.block.overrides.BlockMixerImproved;
import soot.block.overrides.BlockStamperImproved;
import soot.brewing.CaskManager;
import soot.brewing.EssenceType;
import soot.entity.EntityCustomCloud;
import soot.entity.EntityFireCloud;
import soot.entity.EntityMuse;
import soot.entity.EntitySnowpoff;
import soot.fluids.FluidBooze;
import soot.fluids.FluidMolten;
import soot.item.ItemAlchemyGauntlet;
import soot.item.ItemBlockSlab;
import soot.item.ItemEitr;
import soot.item.ItemElixir;
import soot.item.ItemEssence;
import soot.item.ItemMug;
import soot.item.ItemStill;
import soot.item.ItemSulfurClump;
import soot.itemmod.ModifierMundane;
import soot.itemmod.ModifierWitchburn;
import soot.potion.PotionAle;
import soot.potion.PotionExperienceBoost;
import soot.potion.PotionFireLung;
import soot.potion.PotionGlass;
import soot.potion.PotionInnerFire;
import soot.potion.PotionInspiration;
import soot.potion.PotionLifedrinker;
import soot.potion.PotionSnowpoff;
import soot.potion.PotionSteadfast;
import soot.potion.PotionStoutness;
import soot.potion.PotionTipsy;
import soot.tile.TileEntityAlchemyGauge;
import soot.tile.TileEntityAlchemyGlobe;
import soot.tile.TileEntityDecanterBottom;
import soot.tile.TileEntityDecanterTop;
import soot.tile.TileEntityDecanterTopRenderer;
import soot.tile.TileEntityDistillationPipe;
import soot.tile.TileEntityEmberBurst;
import soot.tile.TileEntityInsulation;
import soot.tile.TileEntityRedstoneBin;
import soot.tile.TileEntityScale;
import soot.tile.TileEntityStillBase;
import soot.tile.TileEntityStillTip;
import soot.tile.TileEntitySulfurOre;
import soot.tile.overrides.TileEntityAlchemyPedestalImproved;
import soot.tile.overrides.TileEntityAlchemyTabletImproved;
import soot.tile.overrides.TileEntityBeamCannonImproved;
import soot.tile.overrides.TileEntityCrystalCellImproved;
import soot.tile.overrides.TileEntityDawnstoneAnvilImproved;
import soot.tile.overrides.TileEntityEmberBoreImproved;
import soot.tile.overrides.TileEntityHeatCoilImproved;
import soot.tile.overrides.TileEntityMechAccessorImproved;
import soot.tile.overrides.TileEntityMixerBottomImproved;
import soot.tile.overrides.TileEntityStamperImproved;
import soot.util.HeatManager;
import soot.util.Nope;
import teamroots.embers.RegistryManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.research.ResearchBase;
import teamroots.embers.research.ResearchCategory;
import teamroots.embers.research.ResearchManager;
import teamroots.embers.research.subtypes.ResearchShowItem;
import teamroots.embers.research.subtypes.ResearchSwitchCategory;
import teamroots.embers.tileentity.TileEntityHeatCoil;
import teamroots.embers.upgrade.UpgradeCatalyticPlug;
import teamroots.embers.util.Vec2i;
import teamroots.embers.util.WeightedItemStack;

public class Registry {
    public static ArrayList<Block> MODELLED_BLOCKS = new ArrayList();
    public static ArrayList<Item> MODELLED_ITEMS = new ArrayList();
    public static ArrayList<Block> BLOCKS = new ArrayList();
    public static ArrayList<Item> ITEMS = new ArrayList();
    public static ArrayList<Fluid> FLUIDS = new ArrayList();
    private static ArrayList<Runnable> WRITEBACKS = new ArrayList();
    public static Item.ToolMaterial EITR_TOOL_MATERIAL = EnumHelper.addToolMaterial((String)"soot:eitr", (int)2, (int)512, (float)7.5f, (float)0.0f, (int)24);
    @GameRegistry.ObjectHolder(value="soot:alchemy_globe")
    public static BlockAlchemyGlobe ALCHEMY_GLOBE;
    @GameRegistry.ObjectHolder(value="soot:still")
    public static BlockStill STILL;
    @GameRegistry.ObjectHolder(value="soot:alchemy_gauge")
    public static BlockAlchemyGauge ALCHEMY_GAUGE;
    @GameRegistry.ObjectHolder(value="soot:ember_burst")
    public static BlockEmberBurst EMBER_BURST;
    @GameRegistry.ObjectHolder(value="soot:distillation_pipe")
    public static BlockDistillationPipe DISTILLATION_PIPE;
    @GameRegistry.ObjectHolder(value="soot:insulation")
    public static BlockInsulation INSULATION;
    @GameRegistry.ObjectHolder(value="soot:decanter")
    public static BlockDecanter DECANTER;
    @GameRegistry.ObjectHolder(value="soot:redstone_bin")
    public static BlockRedstoneBin REDSTONE_BIN;
    @GameRegistry.ObjectHolder(value="soot:scale")
    public static BlockScale SCALE;
    @GameRegistry.ObjectHolder(value="soot:sulfur_ore")
    public static BlockSulfurOre SULFUR_ORE;
    @GameRegistry.ObjectHolder(value="soot:caminite_clay")
    public static Block CAMINITE_CLAY;
    @GameRegistry.ObjectHolder(value="soot:caminite_large_tile")
    public static Block CAMINITE_LARGE_TILE;
    @GameRegistry.ObjectHolder(value="soot:signet_antimony")
    public static Item SIGNET_ANTIMONY;
    @GameRegistry.ObjectHolder(value="soot:ingot_antimony")
    public static Item INGOT_ANTIMONY;
    @GameRegistry.ObjectHolder(value="soot:mug")
    public static ItemMug MUG;
    @GameRegistry.ObjectHolder(value="soot:stamp_text_raw")
    public static Item STAMP_TEXT_RAW;
    @GameRegistry.ObjectHolder(value="soot:stamp_text")
    public static Item STAMP_TEXT;
    @GameRegistry.ObjectHolder(value="soot:stamp_nugget_raw")
    public static Item STAMP_NUGGET_RAW;
    @GameRegistry.ObjectHolder(value="soot:stamp_nugget")
    public static Item STAMP_NUGGET;
    @GameRegistry.ObjectHolder(value="soot:sulfur")
    public static Item SULFUR;
    @GameRegistry.ObjectHolder(value="soot:sulfur_clump")
    public static ItemSulfurClump SULFUR_CLUMP;
    @GameRegistry.ObjectHolder(value="soot:mundane_stone")
    public static Item MUNDANE_STONE;
    @GameRegistry.ObjectHolder(value="soot:witch_fire")
    public static Item WITCH_FIRE;
    @GameRegistry.ObjectHolder(value="soot:essence")
    public static ItemEssence ESSENCE;
    @GameRegistry.ObjectHolder(value="soot:alchemy_gauntlet")
    public static ItemAlchemyGauntlet ALCHEMY_GAUNTLET;
    @GameRegistry.ObjectHolder(value="soot:elixir")
    public static ItemElixir ELIXIR;
    @GameRegistry.ObjectHolder(value="soot:eitr")
    public static ItemEitr EITR;
    @GameRegistry.ObjectHolder(value="soot:ale")
    public static Potion POTION_ALE;
    @GameRegistry.ObjectHolder(value="soot:stoutness")
    public static Potion POTION_STOUTNESS;
    @GameRegistry.ObjectHolder(value="soot:inner_fire")
    public static Potion POTION_INNER_FIRE;
    @GameRegistry.ObjectHolder(value="soot:fire_lung")
    public static Potion POTION_FIRE_LUNG;
    @GameRegistry.ObjectHolder(value="soot:steadfast")
    public static Potion POTION_STEADFAST;
    @GameRegistry.ObjectHolder(value="soot:tipsy")
    public static Potion POTION_TIPSY;
    @GameRegistry.ObjectHolder(value="soot:lifedrinker")
    public static Potion POTION_LIFEDRINKER;
    @GameRegistry.ObjectHolder(value="soot:snowpoff")
    public static Potion POTION_SNOWPOFF;
    @GameRegistry.ObjectHolder(value="soot:inspiration")
    public static Potion POTION_INSPIRATION;
    @GameRegistry.ObjectHolder(value="soot:glass")
    public static Potion POTION_GLASS;
    @GameRegistry.ObjectHolder(value="soot:experience_boost")
    public static Potion POTION_EXPERIENCE_BOOST;
    public static Fluid BOILING_WORT;
    public static Fluid BOILING_POTATO_JUICE;
    public static Fluid BOILING_WORMWOOD;
    public static Fluid BOILING_BEETROOT_SOUP;
    public static Fluid ALE;
    public static Fluid VODKA;
    public static Fluid ABSINTHE;
    public static Fluid METHANOL;
    public static Fluid INNER_FIRE;
    public static Fluid UMBER_ALE;
    public static Fluid SNOWPOFF_VODKA;
    public static Fluid BOILING_ROOT_WATER;
    public static Fluid BOILING_AUBERGE;
    public static Fluid ROOT_BEER;
    public static Fluid AUBERGINE_LIQUOR;
    public static final String STONE = "stone";
    public static final String NETHER = "nether";
    public static final String END = "end";
    public static final String SAND = "sand";
    public static final String BETWEEN_STONE = "betweenlands";
    public static final String BETWEEN_PIT = "betweenlands_pit";
    public static final String BETWEEN_GEM = "betweenlands_gem";
    public static final HashMap<String, String> ALTERNATE_ORES;
    public static ModifierBase MUNDANE;
    public static ModifierBase WITCHBURN;
    public static final ResourceLocation PAGE_ICONS;
    public static final double PAGE_ICON_SIZE = 0.09375;

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register(Registry.class);
        Registry.registerBlocks();
        Registry.registerTileEntities();
        Registry.registerEntities();
        Registry.registerFluids();
        Registry.registerCapabilities();
    }

    public static void init() {
        Registry.registerCaskLiquids();
        Registry.registerAccessorTiles();
        Registry.registerModifiers();
        HeatManager.register(RegistryManager.archaic_light, 150);
        HeatManager.register((Block)Blocks.field_150480_ab, 50);
        HeatManager.register(RegistryManager.heat_coil, (world, pos, state) -> {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityHeatCoil) {
                double heat = ((TileEntityHeatCoil)tile).heat;
                return heat > 140.0 ? heat : 0.0;
            }
            return 0.0;
        });
        EITR_TOOL_MATERIAL.setRepairItem(new ItemStack(SULFUR));
        RecipeRegistry.defaultBoreOutput.stacks.add(new WeightedItemStack(new ItemStack(MUNDANE_STONE), 1));
        UpgradeCatalyticPlug.registerBlacklistedTile(TileEntityStillBase.class);
    }

    public static void postInit() {
        Registry.initResearches();
    }

    public static void initResearches() {
        ResearchCategory categoryWorld = ResearchManager.categoryWorld;
        ResearchCategory categoryMechanisms = ResearchManager.categoryMechanisms;
        ResearchCategory categoryMetallurgy = ResearchManager.categoryMetallurgy;
        ResearchCategory categoryAlchemy = ResearchManager.categoryAlchemy;
        ResearchCategory categorySmithing = ResearchManager.categorySmithing;
        ResearchCategory categoryBrewing = new ResearchCategory("brewing", new ResourceLocation("soot", "textures/gui/codex_index.png"), 192.0, 16.0);
        categoryBrewing.addPrerequisite(ResearchManager.dawnstone);
        ResearchBase forgeProjectile = (ResearchBase)ResearchManager.subCategoryProjectileAugments.researches.get(0);
        ResearchBase forgeWeapon = (ResearchBase)ResearchManager.subCategoryWeaponAugments.researches.get(0);
        ResearchManager.subCategoryProjectileAugments.addResearch(new ResearchBase("witch_fire", new ItemStack(WITCH_FIRE), ResearchManager.subCategoryProjectileAugments.popGoodLocation()).addAncestor(forgeProjectile));
        ResearchManager.subCategoryWeaponAugments.addResearch(new ResearchBase("mundane_stone", new ItemStack(MUNDANE_STONE), ResearchManager.subCategoryWeaponAugments.popGoodLocation()).addAncestor(forgeWeapon));
        ResearchManager.researches.add(categoryBrewing);
        categoryWorld.addResearch(new ResearchBase("sulfur", new ItemStack((Item)SULFUR_CLUMP), 12.0, 0.0));
        ResearchBase redstone_bin = new ResearchBase("redstone_bin", new ItemStack((Block)REDSTONE_BIN), 7.0, 2.0).addAncestor(ResearchManager.bin);
        ResearchManager.subCategoryPipes.addResearch(redstone_bin);
        categoryMechanisms.addResearch(new ResearchBase("insulation", new ItemStack((Block)INSULATION), 12.0, 0.0).addAncestor(ResearchManager.hearth_coil));
        categoryMetallurgy.addResearch(new ResearchBase("advanced_emitters", new ItemStack((Block)EMBER_BURST), 2.0, 7.0).addAncestor(ResearchManager.splitter));
        ResearchManager.subCategoryPipes.addResearch(new ResearchBase("scale", new ItemStack((Block)SCALE), 8.0, 0.0).addAncestor(redstone_bin));
        ResearchCategory subCategoryAlchemyMixing = new ResearchCategory("alchemical_mixer", 0.0);
        ResearchBase alchemy_globe = new ResearchBase("alchemy_globe", new ItemStack((Block)ALCHEMY_GLOBE), 5.0, 5.0).addPage(new ResearchBase("alchemy_globe_setup", ItemStack.field_190927_a, 0.0, 0.0)).addPage(new ResearchBase("alchemy_globe_crafting", ItemStack.field_190927_a, 0.0, 0.0));
        subCategoryAlchemyMixing.addResearch(alchemy_globe);
        ResearchBase antimony = new ResearchBase("antimony", new ItemStack(INGOT_ANTIMONY), 4.0, 7.0).addAncestor(alchemy_globe);
        subCategoryAlchemyMixing.addResearch(antimony);
        subCategoryAlchemyMixing.addResearch(new ResearchBase("eitr", new ItemStack((Item)EITR), 8.0, 7.0).addAncestor(antimony));
        subCategoryAlchemyMixing.addResearch(new ResearchBase("antimony_signet", new ItemStack(SIGNET_ANTIMONY), 2.0, 6.0).addAncestor(antimony));
        subCategoryAlchemyMixing.addResearch(new ResearchShowItem("metal_leveling", ItemStack.field_190927_a, 7.0, 4.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack[]{new ItemStack(RegistryManager.ingot_lead), new ItemStack(RegistryManager.ingot_tin), new ItemStack(Items.field_151042_j), new ItemStack(RegistryManager.ingot_copper), new ItemStack(RegistryManager.ingot_silver), new ItemStack(Items.field_151043_k)})).setIconBackground(PAGE_ICONS, 0.09375, 0.0).addAncestor(alchemy_globe));
        ResearchBase still = new ResearchBase("still", new ItemStack((Block)STILL), 6.0, 4.0);
        categoryBrewing.addResearch(still);
        categoryBrewing.addResearch(new ResearchBase("distillation_pipe", new ItemStack((Block)DISTILLATION_PIPE), 8.0, 7.0).addAncestor(still));
        categoryBrewing.addResearch(new ResearchBase("decanter", new ItemStack((Block)DECANTER), 10.0, 7.0).addAncestor(still));
        categoryBrewing.addResearch(new ResearchBase("still_fuel", new ItemStack(RegistryManager.archaic_light), 6.0, 7.0).addAncestor(still));
        ResearchBase alchemy_dial = new ResearchBase("alchemy_dial", new ItemStack((Block)ALCHEMY_GAUGE), 3.5, 6.0).addAncestor(still);
        categoryBrewing.addResearch(alchemy_dial);
        categoryBrewing.addResearch(new ResearchBase("rename", new ItemStack(Items.field_151155_ap), 1.0, 7.0).addAncestor(alchemy_dial));
        Vec2i[] ringPositions = new Vec2i[]{new Vec2i(1, 1), new Vec2i(0, 3), new Vec2i(0, 5), new Vec2i(1, 7), new Vec2i(11, 7), new Vec2i(12, 5), new Vec2i(12, 3), new Vec2i(11, 1), new Vec2i(4, 1), new Vec2i(2, 4), new Vec2i(4, 7), new Vec2i(8, 7), new Vec2i(10, 4), new Vec2i(8, 1)};
        ResearchCategory subCategoryPrimaryEffects = new ResearchCategory("primary_effects", 0.0).pushGoodLocations(ringPositions);
        ResearchCategory subCategorySecondaryEffects = new ResearchCategory("secondary_effects", 0.0).pushGoodLocations(ringPositions);
        ResearchCategory subCategoryTertiaryEffects = new ResearchCategory("tertiary_effects", 0.0).pushGoodLocations(ringPositions);
        subCategoryPrimaryEffects.addResearch(new ResearchBase("ale", MUG.getFilled(CaskManager.getFromFluid(ALE)), subCategoryPrimaryEffects.popGoodLocation()));
        subCategoryPrimaryEffects.addResearch(new ResearchBase("vodka", MUG.getFilled(CaskManager.getFromFluid(VODKA)), subCategoryPrimaryEffects.popGoodLocation()));
        ResearchBase verdigris = new ResearchBase("verdigris", MUG.getFilled(CaskManager.getFromFluid(BOILING_WORMWOOD)), subCategoryPrimaryEffects.popGoodLocation());
        subCategoryPrimaryEffects.addResearch(verdigris);
        subCategoryPrimaryEffects.addResearch(new ResearchBase("absinthe", MUG.getFilled(CaskManager.getFromFluid(ABSINTHE)), subCategoryPrimaryEffects.popGoodLocation()).addAncestor(verdigris));
        subCategoryPrimaryEffects.addResearch(new ResearchBase("methanol", MUG.getFilled(CaskManager.getFromFluid(METHANOL)), subCategoryPrimaryEffects.popGoodLocation()));
        subCategoryPrimaryEffects.addResearch(new ResearchBase("snowpoff_vodka", MUG.getFilled(CaskManager.getFromFluid(SNOWPOFF_VODKA)), subCategoryPrimaryEffects.popGoodLocation()));
        subCategoryPrimaryEffects.addResearch(new ResearchBase("inner_fire", MUG.getFilled(CaskManager.getFromFluid(INNER_FIRE)), subCategoryPrimaryEffects.popGoodLocation()));
        subCategoryPrimaryEffects.addResearch(new ResearchBase("beetroot_soup", MUG.getFilled(CaskManager.getFromFluid(BOILING_BEETROOT_SOUP)), subCategoryPrimaryEffects.popGoodLocation()));
        subCategorySecondaryEffects.addResearch(new ResearchBase("lifedrinker", new ItemStack(Items.field_151073_bk), subCategorySecondaryEffects.popGoodLocation()));
        subCategorySecondaryEffects.addResearch(new ResearchBase("steadfast", new ItemStack(Items.field_151150_bK), subCategorySecondaryEffects.popGoodLocation()));
        subCategorySecondaryEffects.addResearch(new ResearchBase("experience_boost", new ItemStack(Items.field_151110_aK), subCategorySecondaryEffects.popGoodLocation()));
        subCategorySecondaryEffects.addResearch(new ResearchBase("glass", new ItemStack(Blocks.field_150359_w), subCategorySecondaryEffects.popGoodLocation()));
        subCategoryTertiaryEffects.addResearch(new ResearchBase("duration", new ItemStack(Items.field_151137_ax), subCategoryTertiaryEffects.popGoodLocation()));
        subCategoryTertiaryEffects.addResearch(new ResearchBase("sweetening", new ItemStack(Items.field_151102_aT), subCategoryTertiaryEffects.popGoodLocation()));
        subCategoryTertiaryEffects.addResearch(new ResearchBase("purification", new ItemStack(Items.field_179563_cD), subCategoryTertiaryEffects.popGoodLocation()));
        subCategoryTertiaryEffects.addResearch(new ResearchBase("tainting", new ItemStack(Items.field_151071_bq), subCategoryTertiaryEffects.popGoodLocation()));
        subCategoryTertiaryEffects.addResearch(new ResearchBase("healing", new ItemStack(Items.field_151075_bm), subCategoryTertiaryEffects.popGoodLocation()));
        subCategoryTertiaryEffects.addResearch(new ResearchBase("cooling", new ItemStack(Blocks.field_150432_aD), subCategoryTertiaryEffects.popGoodLocation()));
        subCategoryTertiaryEffects.addResearch(new ResearchBase("stew", new ItemStack(Items.field_151174_bG), subCategoryTertiaryEffects.popGoodLocation()));
        subCategoryTertiaryEffects.addResearch(new ResearchBase("essence", ESSENCE.getStack(EssenceType.CHAOS), subCategoryTertiaryEffects.popGoodLocation()));
        categoryAlchemy.addResearch(Registry.makeCategorySwitch(subCategoryAlchemyMixing, 5, 0, new ItemStack((Block)ALCHEMY_GLOBE), 0, 1).addAncestor(ResearchManager.waste));
        categoryBrewing.addResearch(Registry.makeCategorySwitch(subCategoryPrimaryEffects, 2, 4, ItemStack.field_190927_a, 1, 1).addAncestor(still));
        categoryBrewing.addResearch(Registry.makeCategorySwitch(subCategorySecondaryEffects, 6, 1, ItemStack.field_190927_a, 2, 1).addAncestor(still));
        categoryBrewing.addResearch(Registry.makeCategorySwitch(subCategoryTertiaryEffects, 10, 4, ItemStack.field_190927_a, 3, 1).addAncestor(still));
    }

    private static ResearchBase makeCategorySwitch(ResearchCategory targetCategory, int x, int y, ItemStack icon, int u, int v) {
        return new ResearchSwitchCategory(targetCategory.name + "_category", icon, (double)x, (double)y).setTargetCategory(targetCategory).setIconBackground(PAGE_ICONS, 0.09375 * (double)u, 0.09375 * (double)v);
    }

    public static void registerCaskLiquids() {
        BOILING_WORT = FluidRegistry.getFluid((String)"boiling_wort");
        BOILING_POTATO_JUICE = FluidRegistry.getFluid((String)"boiling_potato_juice");
        BOILING_WORMWOOD = FluidRegistry.getFluid((String)"boiling_wormwood");
        BOILING_BEETROOT_SOUP = FluidRegistry.getFluid((String)"boiling_beetroot_soup");
        ALE = FluidRegistry.getFluid((String)"dwarven_ale");
        VODKA = FluidRegistry.getFluid((String)"vodka");
        INNER_FIRE = FluidRegistry.getFluid((String)"inner_fire");
        UMBER_ALE = FluidRegistry.getFluid((String)"umber_ale");
        ABSINTHE = FluidRegistry.getFluid((String)"absinthe");
        METHANOL = FluidRegistry.getFluid((String)"methanol");
        SNOWPOFF_VODKA = FluidRegistry.getFluid((String)"snowpoff");
        CaskManager.register(new CaskManager.CaskLiquid(BOILING_WORT, 1, -7764714));
        CaskManager.register(new CaskManager.CaskLiquid(BOILING_POTATO_JUICE, 1, -1250649));
        CaskManager.register(new CaskManager.CaskLiquid(BOILING_WORMWOOD, 1, -5242995));
        CaskManager.register(new CaskManager.CaskLiquid(BOILING_BEETROOT_SOUP, 1, -3789312));
        CaskManager.register(new CaskManager.CaskLiquid(ALE, 2, -1997268));
        CaskManager.register(new CaskManager.CaskLiquid(VODKA, 1, -3608593));
        CaskManager.register(new CaskManager.CaskLiquid(INNER_FIRE, 2, -45824));
        CaskManager.register(new CaskManager.CaskLiquid(UMBER_ALE, 2, -12111338));
        CaskManager.register(new CaskManager.CaskLiquid(ABSINTHE, 1, -10944722));
        CaskManager.register(new CaskManager.CaskLiquid(METHANOL, 1, -10066381));
        CaskManager.register(new CaskManager.CaskLiquid(SNOWPOFF_VODKA, 2, -3938569));
    }

    public static void registerAccessorTiles() {
        TileEntityMechAccessorImproved.registerAccessibleTile(TileEntityStillBase.class);
    }

    public static void registerBlocks() {
        Nope.shutupForge(Registry::registerOverrides);
        BlockSulfurOre sulfurOre = (BlockSulfurOre)new BlockSulfurOre(Material.field_151576_e).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("sulfur_ore", sulfurOre, new ItemBlock((Block)sulfurOre));
        BlockEmberBurst emberBurst = (BlockEmberBurst)new BlockEmberBurst(Material.field_151576_e).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("ember_burst", emberBurst, new ItemBlock((Block)emberBurst));
        BlockRedstoneBin redstoneBin = (BlockRedstoneBin)new BlockRedstoneBin(Material.field_151573_f, "redstone_bin").setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.0f).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("redstone_bin", (Block)redstoneBin, new ItemBlock((Block)redstoneBin));
        BlockScale scale = (BlockScale)new BlockScale(Material.field_151573_f).func_149711_c(1.6f).func_149713_g(0).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("scale", scale, new ItemBlock((Block)scale));
        BlockAlchemyGlobe alchemyGlobe = (BlockAlchemyGlobe)new BlockAlchemyGlobe(Material.field_151576_e).func_149711_c(1.6f).func_149713_g(0).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("alchemy_globe", alchemyGlobe, new ItemBlock((Block)alchemyGlobe));
        BlockInsulation insulation = (BlockInsulation)new BlockInsulation(Material.field_151576_e).func_149711_c(1.6f).func_149713_g(1).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("insulation", insulation, new ItemBlock((Block)insulation));
        BlockDistillationPipe distillationPipe = (BlockDistillationPipe)new BlockDistillationPipe(Material.field_151573_f).func_149711_c(1.6f).func_149713_g(1).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("distillation_pipe", distillationPipe, new ItemBlock((Block)distillationPipe));
        BlockDecanter decanter = (BlockDecanter)new BlockDecanter().func_149711_c(1.6f).func_149713_g(1).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("decanter", decanter, new ItemBlock((Block)decanter));
        BlockAlchemyGauge alchemyGauge = (BlockAlchemyGauge)new BlockAlchemyGauge(Material.field_151573_f).func_149711_c(1.6f).func_149713_g(0).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("alchemy_gauge", (Block)alchemyGauge, new ItemBlock((Block)alchemyGauge));
        Registry.registerItem("signet_antimony", new Item().func_77637_a(Soot.creativeTab));
        Registry.registerItem("ingot_antimony", new Item().func_77637_a(Soot.creativeTab));
        Registry.registerItem("mug", new ItemMug().func_77637_a(Soot.creativeTab));
        Registry.registerItem("stamp_text_raw", new Item().func_77637_a(Soot.creativeTab));
        Registry.registerItem("stamp_text", new Item().func_77637_a(Soot.creativeTab));
        Registry.registerItem("stamp_nugget_raw", new Item().func_77637_a(Soot.creativeTab));
        Registry.registerItem("stamp_nugget", new Item().func_77637_a(Soot.creativeTab));
        Registry.registerItem("sulfur", new Item().func_77637_a(Soot.creativeTab));
        Registry.registerItem("sulfur_clump", new ItemSulfurClump().func_77625_d(1).func_77637_a(Soot.creativeTab));
        Registry.registerItem("eitr", new ItemEitr(EITR_TOOL_MATERIAL).func_77637_a(Soot.creativeTab));
        Registry.registerItem("mundane_stone", new Item().func_77637_a(Soot.creativeTab));
        Registry.registerItem("witch_fire", new Item().func_77637_a(Soot.creativeTab));
        Registry.registerItem("essence", new ItemEssence().func_77637_a(Soot.creativeTab));
        BlockStill still = (BlockStill)new BlockStill().func_149711_c(1.6f).func_149713_g(0).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("still", still, new ItemStill(still));
        Block caminiteClay = new Block(Material.field_151571_B, MapColor.field_193561_M).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("caminite_clay", caminiteClay, new ItemBlock(caminiteClay));
        Block caminiteTiles = new Block(Material.field_151576_e, MapColor.field_193561_M).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block caminiteTilesSlab = new BlockModSlab(Material.field_151576_e, MapColor.field_193561_M).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block caminiteTilesStairs = new BlockModStairs(caminiteTiles.func_176223_P()).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("caminite_tiles", caminiteTiles, new ItemBlock(caminiteTiles));
        Registry.registerBlock("caminite_tiles_slab", caminiteTilesSlab, new ItemBlockSlab(caminiteTilesSlab, caminiteTiles));
        Registry.registerBlock("caminite_tiles_stairs", caminiteTilesStairs, new ItemBlock(caminiteTilesStairs));
        Block caminiteLargeTile = new Block(Material.field_151576_e, MapColor.field_193561_M).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block caminiteLargeTileSlab = new BlockModSlab(Material.field_151576_e, MapColor.field_193561_M).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block caminiteLargeTileStairs = new BlockModStairs(caminiteLargeTile.func_176223_P()).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("caminite_large_tile", caminiteLargeTile, new ItemBlock(caminiteLargeTile));
        Registry.registerBlock("caminite_large_tile_slab", caminiteLargeTileSlab, new ItemBlockSlab(caminiteLargeTileSlab, caminiteLargeTile));
        Registry.registerBlock("caminite_large_tile_stairs", caminiteLargeTileStairs, new ItemBlock(caminiteLargeTileStairs));
        Block archaicTileSlab = new BlockModSlab(Material.field_151576_e, MapColor.field_193573_Y).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block archaicTileStairs = new BlockModStairs(RegistryManager.archaic_tile.func_176223_P()).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("archaic_tile_slab", archaicTileSlab, new ItemBlockSlab(archaicTileSlab, RegistryManager.archaic_tile));
        Registry.registerBlock("archaic_tile_stairs", archaicTileStairs, new ItemBlock(archaicTileStairs));
        Block archaicBigBrick = new Block(Material.field_151576_e, MapColor.field_193573_Y).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block archaicBigBrickSlab = new BlockModSlab(Material.field_151576_e, MapColor.field_193573_Y).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block archaicBigBrickStairs = new BlockModStairs(archaicBigBrick.func_176223_P()).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("archaic_big_bricks", archaicBigBrick, new ItemBlock(archaicBigBrick));
        Registry.registerBlock("archaic_big_bricks_slab", archaicBigBrickSlab, new ItemBlockSlab(archaicBigBrickSlab, archaicBigBrick));
        Registry.registerBlock("archaic_big_bricks_stairs", archaicBigBrickStairs, new ItemBlock(archaicBigBrickStairs));
        Block archaicBrickSlab = new BlockModSlab(Material.field_151576_e, MapColor.field_193573_Y).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block archaicBrickStairs = new BlockModStairs(RegistryManager.archaic_bricks.func_176223_P()).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("archaic_bricks_slab", archaicBrickSlab, new ItemBlockSlab(archaicBrickSlab, RegistryManager.archaic_bricks));
        Registry.registerBlock("archaic_bricks_stairs", archaicBrickStairs, new ItemBlock(archaicBrickStairs));
        Block sealedPlanksSlab = new BlockModSlab(Material.field_151575_d, MapColor.field_193573_Y).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block sealedPlanksStairs = new BlockModStairs(RegistryManager.sealed_planks.func_176223_P()).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("sealed_planks_slab", sealedPlanksSlab, new ItemBlockSlab(sealedPlanksSlab, RegistryManager.sealed_planks));
        Registry.registerBlock("sealed_planks_stairs", sealedPlanksStairs, new ItemBlock(sealedPlanksStairs));
        Block sealedTile = new Block(Material.field_151575_d, MapColor.field_193573_Y).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block sealedTileSlab = new BlockModSlab(Material.field_151575_d, MapColor.field_193573_Y).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block sealedTileStairs = new BlockModStairs(sealedTile.func_176223_P()).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("sealed_tile", sealedTile, new ItemBlock(sealedTile));
        Registry.registerBlock("sealed_tile_slab", sealedTileSlab, new ItemBlockSlab(sealedTileSlab, sealedTile));
        Registry.registerBlock("sealed_tile_stairs", sealedTileStairs, new ItemBlock(sealedTileStairs));
        Block sealedKeg = new BlockPillar(Material.field_151575_d, MapColor.field_193573_Y).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block sealedPillar = new BlockPillar(Material.field_151575_d, MapColor.field_193573_Y).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("sealed_keg", sealedKeg, new ItemBlock(sealedKeg));
        Registry.registerBlock("sealed_pillar", sealedPillar, new ItemBlock(sealedPillar));
        Block wroughtTile = new Block(Material.field_151573_f, MapColor.field_151670_w).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block wroughtPlatform = new Block(Material.field_151573_f, MapColor.field_151670_w).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Block wroughtPlatformSlab = new BlockModSlab(Material.field_151573_f, MapColor.field_151670_w).func_149711_c(1.6f).func_149647_a(Soot.creativeTab);
        Registry.registerBlock("wrought_tile", wroughtTile, new ItemBlock(wroughtTile));
        Registry.registerBlock("wrought_platform", wroughtPlatform, new ItemBlock(wroughtPlatform));
        Registry.registerBlock("wrought_platform_slab", wroughtPlatformSlab, new ItemBlockSlab(wroughtPlatformSlab, wroughtPlatform));
    }

    public static void registerOverrides() {
        if (Config.OVERRIDE_BORE) {
            BlockEmberBoreImproved boreImproved = (BlockEmberBoreImproved)new BlockEmberBoreImproved(Material.field_151576_e, "ember_bore", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.0f);
            Registry.registerBlock((Block)boreImproved, false);
        }
        if (Config.OVERRIDE_STAMPER) {
            BlockStamperImproved stamperImproved = (BlockStamperImproved)new BlockStamperImproved(Material.field_151576_e, "stamper", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.0f);
            Registry.registerBlock((Block)stamperImproved, false);
        }
        if (Config.OVERRIDE_MIXER) {
            BlockMixerImproved mixerImproved = (BlockMixerImproved)new BlockMixerImproved(Material.field_151576_e, "mixer", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.0f);
            Registry.registerBlock((Block)mixerImproved, false);
        }
        if (Config.OVERRIDE_DAWNSTONE_ANVIL) {
            BlockDawnstoneAnvilImproved dawnstoneAnvilImproved = (BlockDawnstoneAnvilImproved)new BlockDawnstoneAnvilImproved(Material.field_151576_e, "dawnstone_anvil", true).setHarvestProperties("pickaxe", 1).setIsFullCube(false).setIsOpaqueCube(false).func_149711_c(1.6f).func_149713_g(0);
            Registry.registerBlock((Block)dawnstoneAnvilImproved, false);
        }
        if (Config.OVERRIDE_BEAM_CANNON) {
            BlockBeamCannonImproved beamCannonImproved = (BlockBeamCannonImproved)new BlockBeamCannonImproved(Material.field_151576_e, "beam_cannon", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.6f);
            Registry.registerBlock((Block)beamCannonImproved, false);
        }
        if (Config.OVERRIDE_ALCHEMY_TABLET) {
            BlockAlchemyTabletImproved alchemyTabletImproved = (BlockAlchemyTabletImproved)new BlockAlchemyTabletImproved(Material.field_151576_e, "alchemy_tablet", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.6f);
            Registry.registerBlock((Block)alchemyTabletImproved, false);
        }
        if (Config.OVERRIDE_ALCHEMY_PEDESTAL) {
            BlockAlchemyPedestalImproved alchemyPedestalImproved = (BlockAlchemyPedestalImproved)new BlockAlchemyPedestalImproved(Material.field_151576_e, "alchemy_pedestal", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.6f);
            Registry.registerBlock((Block)alchemyPedestalImproved, false);
        }
        if (Config.OVERRIDE_HEARTH_COIL) {
            BlockHeatCoilImproved heatCoilImproved = (BlockHeatCoilImproved)new BlockHeatCoilImproved(Material.field_151576_e, "heat_coil", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.0f);
            Registry.registerBlock((Block)heatCoilImproved, false);
        }
        if (Config.OVERRIDE_MECH_ACCESSOR) {
            BlockMechAccessorImproved accessorImproved = (BlockMechAccessorImproved)new BlockMechAccessorImproved(Material.field_151576_e, "mech_accessor", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.0f);
            Registry.registerBlock((Block)accessorImproved, false);
        }
        if (Config.OVERRIDE_CRYSTAL_CELL) {
            BlockCrystalCellImproved crystalCellImproved = (BlockCrystalCellImproved)new BlockCrystalCellImproved(Material.field_151576_e, "crystal_cell", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.0f);
            Registry.registerBlock((Block)crystalCellImproved, false);
        }
    }

    public static void registerFluids() {
        Registry.registerFluid(new FluidBooze("boiling_wort", new ResourceLocation("soot", "blocks/wort"), new ResourceLocation("soot", "blocks/wort_flowing")).setTemperature(500), false);
        Registry.registerFluid(new FluidBooze("boiling_potato_juice", new ResourceLocation("soot", "blocks/potato_juice"), new ResourceLocation("soot", "blocks/potato_juice_flowing")).setTemperature(500), false);
        Registry.registerFluid(new FluidBooze("boiling_wormwood", new ResourceLocation("soot", "blocks/verdigris"), new ResourceLocation("soot", "blocks/verdigris_flowing")).setTemperature(500), false);
        Registry.registerFluid(new FluidBooze("boiling_beetroot_soup", new ResourceLocation("soot", "blocks/beetsoup"), new ResourceLocation("soot", "blocks/beetsoup_flowing")).setTemperature(500), false);
        Registry.registerFluid(new FluidBooze("dwarven_ale", new ResourceLocation("soot", "blocks/ale"), new ResourceLocation("soot", "blocks/ale_flowing")), false);
        Registry.registerFluid(new FluidBooze("vodka", new ResourceLocation("soot", "blocks/vodka"), new ResourceLocation("soot", "blocks/vodka_flowing")), false);
        Registry.registerFluid(new FluidBooze("inner_fire", new ResourceLocation("soot", "blocks/inner_fire"), new ResourceLocation("soot", "blocks/inner_fire_flowing")), false);
        Registry.registerFluid(new FluidBooze("umber_ale", new ResourceLocation("soot", "blocks/umber_ale"), new ResourceLocation("soot", "blocks/umber_ale_flowing")), false);
        Registry.registerFluid(new FluidBooze("methanol", new ResourceLocation("soot", "blocks/methanol"), new ResourceLocation("soot", "blocks/methanol_flowing")), false);
        Registry.registerFluid(new FluidBooze("absinthe", new ResourceLocation("soot", "blocks/absinthe"), new ResourceLocation("soot", "blocks/absinthe_flowing")), false);
        Registry.registerFluid(new FluidBooze("snowpoff", new ResourceLocation("soot", "blocks/snowpoff"), new ResourceLocation("soot", "blocks/snowpoff_flowing")), false);
        Registry.registerFluid(new FluidMolten("antimony", new ResourceLocation("soot", "blocks/molten_antimony"), new ResourceLocation("soot", "blocks/molten_antimony_flowing")), true);
        Registry.registerFluid(new FluidMolten("sugar", new ResourceLocation("soot", "blocks/molten_sugar"), new ResourceLocation("soot", "blocks/molten_sugar_flowing")), true);
    }

    private static void registerFluid(Fluid fluid, boolean withBucket) {
        FluidRegistry.registerFluid((Fluid)fluid);
        if (withBucket) {
            FluidRegistry.addBucketForFluid((Fluid)fluid);
        }
        FLUIDS.add(fluid);
    }

    public static void registerBlockModels() {
        for (Block block : MODELLED_BLOCKS) {
            Soot.proxy.registerBlockModel(block);
        }
    }

    public static void registerItemModels() {
        for (Item item : MODELLED_ITEMS) {
            Soot.proxy.registerItemModel(item);
        }
    }

    public static void registerBlock(String id, Block block, ItemBlock itemBlock) {
        Registry.registerBlock(id, block);
        Registry.registerItem(id, (Item)itemBlock);
    }

    public static void registerBlock(String id, Block block) {
        if (block.getRegistryName() == null) {
            block.setRegistryName("soot", id);
        }
        block.func_149663_c(id);
        Registry.registerBlock(block, true);
    }

    public static void registerBlock(Block block, boolean hasmodel) {
        BLOCKS.add(block);
        if (hasmodel) {
            MODELLED_BLOCKS.add(block);
        }
    }

    public static void registerItem(String id, Item item) {
        item.setRegistryName("soot", id);
        item.func_77655_b(id);
        Registry.registerItem(item, true);
    }

    public static void registerItem(Item item, boolean hasmodel) {
        ITEMS.add(item);
        if (hasmodel) {
            MODELLED_ITEMS.add(item);
        }
    }

    public static void registerTileEntities() {
        Registry.registerTileEntity(TileEntitySulfurOre.class);
        Registry.registerTileEntity(TileEntityEmberBurst.class);
        Registry.registerTileEntity(TileEntityAlchemyGauge.class);
        Registry.registerTileEntity(TileEntityRedstoneBin.class);
        Registry.registerTileEntity(TileEntityScale.class);
        Registry.registerTileEntity(TileEntityStillBase.class);
        Registry.registerTileEntity(TileEntityStillTip.class);
        Registry.registerTileEntity(TileEntityEmberBoreImproved.class);
        Registry.registerTileEntity(TileEntityStamperImproved.class);
        Registry.registerTileEntity(TileEntityMixerBottomImproved.class);
        Registry.registerTileEntity(TileEntityDawnstoneAnvilImproved.class);
        Registry.registerTileEntity(TileEntityHeatCoilImproved.class);
        Registry.registerTileEntity(TileEntityBeamCannonImproved.class);
        Registry.registerTileEntity(TileEntityAlchemyTabletImproved.class);
        Registry.registerTileEntity(TileEntityAlchemyPedestalImproved.class);
        Registry.registerTileEntity(TileEntityMechAccessorImproved.class);
        Registry.registerTileEntity(TileEntityCrystalCellImproved.class);
        Registry.registerTileEntity(TileEntityAlchemyGlobe.class);
        Registry.registerTileEntity(TileEntityInsulation.class);
        Registry.registerTileEntity(TileEntityDistillationPipe.class);
        Registry.registerTileEntity(TileEntityDecanterBottom.class);
        Registry.registerTileEntity(TileEntityDecanterTop.class);
    }

    private static void registerEntities() {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("soot", "firecloud"), EntityFireCloud.class, (String)"firecloud", (int)0, (Object)Soot.instance, (int)80, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("soot", "snowpoff"), EntitySnowpoff.class, (String)"snowpoff", (int)1, (Object)Soot.instance, (int)80, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("soot", "muse"), EntityMuse.class, (String)"muse", (int)2, (Object)Soot.instance, (int)80, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("soot", "cloud"), EntityCustomCloud.class, (String)"cloud", (int)3, (Object)Soot.instance, (int)80, (int)1, (boolean)true);
    }

    public static void registerModifiers() {
        MUNDANE = new ModifierMundane();
        WITCHBURN = new ModifierWitchburn();
        EmbersAPI.registerModifier((Item)MUNDANE_STONE, (ModifierBase)MUNDANE);
        EmbersAPI.registerModifier((Item)WITCH_FIRE, (ModifierBase)WITCHBURN);
    }

    public static void registerCapabilities() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : BLOCKS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : ITEMS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        WRITEBACKS.forEach(Runnable::run);
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().register(new PotionAle().setRegistryName("soot", "ale"));
        event.getRegistry().register(new PotionTipsy().setRegistryName("soot", "tipsy"));
        event.getRegistry().register(new PotionStoutness().setRegistryName("soot", "stoutness"));
        event.getRegistry().register(new PotionInnerFire().setRegistryName("soot", "inner_fire"));
        event.getRegistry().register(new PotionFireLung().setRegistryName("soot", "fire_lung"));
        event.getRegistry().register(new PotionSteadfast().setRegistryName("soot", "steadfast"));
        event.getRegistry().register(new PotionLifedrinker().setRegistryName("soot", "lifedrinker"));
        event.getRegistry().register(new PotionSnowpoff().setRegistryName("soot", "snowpoff"));
        event.getRegistry().register(new PotionInspiration().setRegistryName("soot", "inspiration"));
        event.getRegistry().register(new PotionGlass().setRegistryName("soot", "glass"));
        event.getRegistry().register(new PotionExperienceBoost().setRegistryName("soot", "experience_boost"));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent event) {
        TextureMap map = event.getMap();
        map.func_174942_a(new ResourceLocation("soot", "entity/particle_dawnstone"));
        map.func_174942_a(TileEntityDecanterTopRenderer.ESSENCE_STILL);
        map.func_174942_a(TileEntityDecanterTopRenderer.ESSENCE_FLOWING);
    }

    private static void registerTileEntity(Class<? extends TileEntity> tile) {
        GameRegistry.registerTileEntity(tile, (String)tile.getSimpleName().toLowerCase());
    }

    static {
        ALTERNATE_ORES = new HashMap();
        PAGE_ICONS = new ResourceLocation("soot", "textures/gui/codex_pageicons.png");
    }
}

