/*
 * Decompiled with CFR 0.152.
 */
package soot.block;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import soot.brewing.FluidModifier;
import soot.tile.TileEntityAlchemyGauge;
import soot.util.FluidUtil;
import teamroots.embers.block.BlockBaseGauge;

public class BlockAlchemyGauge
extends BlockBaseGauge {
    public static final String DIAL_TYPE = "alchemy";

    public BlockAlchemyGauge(Material blockMaterialIn) {
        super(blockMaterialIn);
        this.setIsFullCube(false);
        this.setIsOpaqueCube(false);
        this.setHarvestProperties("pickaxe", 0);
        this.func_149711_c(1.0f);
    }

    protected void getTEData(EnumFacing facing, ArrayList<String> text, TileEntity tile) {
        IFluidHandler handler;
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing) && (handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) != null) {
            IFluidTankProperties[] properties;
            for (IFluidTankProperties property : properties = handler.getTankProperties()) {
                FluidStack contents = property.getContents();
                if (contents == null) continue;
                this.fillBrewData(text, contents);
            }
        }
    }

    public void fillBrewData(ArrayList<String> text, FluidStack contents) {
        Fluid fluid = contents.getFluid();
        text.add(TextFormatting.BOLD + fluid.getLocalizedName(contents));
        NBTTagCompound compound = FluidUtil.getModifiers(contents);
        for (String key : FluidUtil.SORTED_MODIFIER_KEYS) {
            String formattedText;
            FluidModifier modifier = FluidUtil.MODIFIERS.get(key);
            if (modifier.isDefault(compound, fluid) || (formattedText = modifier.getFormattedText(compound, fluid)).isEmpty()) continue;
            text.add(formattedText);
        }
    }

    public String getDialType() {
        return DIAL_TYPE;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityAlchemyGauge();
    }
}

