/*
 * Decompiled with CFR 0.152.
 */
package soot.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import soot.tile.TileEntityDecanterBottom;
import soot.tile.TileEntityDecanterTop;
import teamroots.embers.tileentity.ITileEntityBase;

public class BlockDecanter
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");

    public BlockDecanter() {
        super(Material.field_151576_e);
    }

    public boolean func_149710_n(IBlockState state) {
        return true;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return BlockRenderLayer.SOLID == layer || BlockRenderLayer.TRANSLUCENT == layer;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TOP});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() | ((Boolean)state.func_177229_b((IProperty)TOP) != false ? 4 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(meta >> 2 > 0));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        boolean isTop = (Boolean)state.func_177229_b((IProperty)TOP);
        if (isTop) {
            return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
        }
        return field_185505_j;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ITileEntityBase) {
            return ((ITileEntityBase)tileEntity).activate(world, pos, state, player, hand, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        this.deleteParts(world, pos, true, null);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && this.isIntact(world, pos)) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        this.deleteParts(world, pos, true, player);
    }

    private boolean isIntact(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        BlockPos base = this.getBase(pos, (Boolean)state.func_177229_b((IProperty)TOP));
        return world.func_180495_p(base).func_177230_c() == this && world.func_180495_p(base.func_177984_a()).func_177230_c() == this;
    }

    private void deleteParts(World world, BlockPos pos, boolean notifyTile, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        BlockPos base = this.getBase(pos, (Boolean)state.func_177229_b((IProperty)TOP));
        this.deletePart(world, base, notifyTile, player);
        this.deletePart(world, base.func_177984_a(), notifyTile, player);
    }

    private void deletePart(World world, BlockPos pos, boolean notifyTile, EntityPlayer player) {
        TileEntity te;
        if (notifyTile && (te = world.func_175625_s(pos)) instanceof ITileEntityBase) {
            ((ITileEntityBase)te).breakBlock(world, pos, world.func_180495_p(pos), player);
        }
        world.func_175698_g(pos);
    }

    private BlockPos getBase(BlockPos pos, boolean isTop) {
        if (isTop) {
            return pos.func_177977_b();
        }
        return pos;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()) == Blocks.field_150350_a.func_176223_P();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing placementFacing = facing.func_176734_d();
        if (placementFacing.func_176740_k().func_176720_b()) {
            placementFacing = placer.func_174811_aO();
        }
        return this.func_176223_P().func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)placementFacing);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        boolean isTop = (Boolean)state.func_177229_b((IProperty)TOP);
        BlockPos base = pos;
        if (isTop) {
            base = base.func_177977_b();
        }
        if (isTop) {
            world.func_175656_a(base, state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)));
        }
        if (!isTop) {
            world.func_175656_a(base.func_177984_a(), state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)));
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        boolean isTop = (Boolean)state.func_177229_b((IProperty)TOP);
        if (isTop) {
            return new TileEntityDecanterTop();
        }
        return new TileEntityDecanterBottom();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a((IProperty)FACING, (Comparable)mirrorIn.func_185803_b((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

