/*
 * Decompiled with CFR 0.152.
 */
package soot.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import soot.tile.TileEntityScale;

public class BlockScale
extends Block {
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    public static final PropertyBool HORIZONTAL = PropertyBool.func_177716_a((String)"horizontal");

    public BlockScale(Material blockMaterialIn) {
        super(blockMaterialIn);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)));
    }

    public EnumFacing.Axis getAxis(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HORIZONTAL) != false ? EnumFacing.Axis.X : EnumFacing.Axis.Z;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile;
        if (side == null || side.func_176740_k().func_176720_b()) {
            return 0;
        }
        EnumFacing.Axis axis = this.getAxis(state);
        EnumFacing rotatedSide = side.func_176746_e();
        if (!((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue() && axis.apply(rotatedSide) && (tile = world.func_175625_s(pos.func_177984_a())) instanceof TileEntityScale) {
            int diff = ((TileEntityScale)tile).getWeightDifference();
            return rotatedSide.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE && diff <= 0 || rotatedSide.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && diff >= 0 ? 15 : 0;
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a((IProperty)HORIZONTAL, (Comparable)Boolean.valueOf((meta & 2) == 2));
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)TOP) != false ? 1 : 0) | ((Boolean)state.func_177229_b((IProperty)HORIZONTAL) != false ? 2 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TOP, HORIZONTAL});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing playerFacing = placer.func_174811_aO();
        return this.func_176223_P().func_177226_a((IProperty)HORIZONTAL, (Comparable)Boolean.valueOf(playerFacing.func_176740_k() == EnumFacing.Axis.X));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos.func_177984_a()) && super.func_176196_c(worldIn, pos);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        boolean top = (Boolean)state.func_177229_b((IProperty)TOP);
        if ((top && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this || !top && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) && !world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        if (!top) {
            world.func_175698_g(pos.func_177984_a());
        } else {
            world.func_175698_g(pos.func_177977_b());
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        IBlockState state;
        boolean top;
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        if (!(top = ((Boolean)(state = world.func_180495_p(pos)).func_177229_b((IProperty)TOP)).booleanValue())) {
            world.func_175698_g(pos.func_177984_a());
        } else {
            world.func_175698_g(pos.func_177977_b());
        }
        world.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            world.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)));
        } else {
            world.func_175656_a(pos.func_177977_b(), state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TOP);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TOP) != false ? new TileEntityScale() : null;
    }
}

