/*
 * Decompiled with CFR 0.152.
 */
package soot.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import soot.Registry;
import soot.tile.TileEntitySulfurOre;

public class BlockSulfurOre
extends Block {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockSulfurOre(Material materialIn) {
        super(materialIn);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        drops.add((Object)Registry.SULFUR_CLUMP.withSize(rand.nextInt(30)));
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public void activateVent(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue() && (tile = worldIn.func_175625_s(pos)) instanceof TileEntitySulfurOre) {
            ((TileEntitySulfurOre)tile).activate();
        }
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        this.activateVent(worldIn, pos, state);
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        IBlockState state = worldIn.func_180495_p(pos);
        this.activateVent(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (blockIn != this) {
            this.activateVent(worldIn, pos, state);
        }
    }

    public boolean func_149710_n(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 1 : 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntitySulfurOre();
    }
}

