/*
 * Decompiled with CFR 0.152.
 */
package soot.brewing;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.fluids.FluidStack;

public abstract class AlchemyDelivery {
    private static List<AlchemyDelivery> REGISTRY = new ArrayList<AlchemyDelivery>();
    double priority;

    public static AlchemyDelivery get(FluidStack stack) {
        for (AlchemyDelivery effect : REGISTRY) {
            if (!effect.matches(stack)) continue;
            return effect;
        }
        return null;
    }

    public abstract boolean matches(FluidStack var1);

    public static void register(AlchemyDelivery delivery) {
        REGISTRY.add(delivery);
        REGISTRY.sort(AlchemyDelivery::compare);
    }

    private static int compare(AlchemyDelivery a, AlchemyDelivery b) {
        return Objects.compare(a.priority, b.priority, Double::compareTo);
    }
}

