/*
 * Decompiled with CFR 0.152.
 */
package soot.brewing;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.fluids.FluidStack;

public class AlchemyEffect {
    private static List<AlchemyEffect> REGISTRY = new ArrayList<AlchemyEffect>();
    double priority;

    public static AlchemyEffect get(FluidStack stack) {
        for (AlchemyEffect effect : REGISTRY) {
            if (!effect.matches(stack)) continue;
            return effect;
        }
        return null;
    }

    private boolean matches(FluidStack stack) {
        return false;
    }

    public static void register(AlchemyEffect effect) {
        REGISTRY.add(effect);
        REGISTRY.sort(AlchemyEffect::compare);
    }

    private static int compare(AlchemyEffect a, AlchemyEffect b) {
        return Objects.compare(a.priority, b.priority, Double::compareTo);
    }
}

