/*
 * Decompiled with CFR 0.152.
 */
package soot.brewing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import soot.brewing.DeliveryType;
import soot.brewing.FluidModifier;
import soot.brewing.deliverytypes.DeliveryBlast;
import soot.util.FluidUtil;

public class CaskManager {
    public static ArrayList<CaskLiquid> liquids = new ArrayList();
    public static Map<String, DeliveryType.IGenerator> deliveryTypes = new HashMap<String, DeliveryType.IGenerator>();

    public static DeliveryType.IGenerator getDeliveryType(FluidStack fluidStack) {
        NBTTagCompound compound = FluidUtil.getModifiers(fluidStack);
        Fluid fluid = fluidStack != null ? fluidStack.getFluid() : null;
        FluidUtil.getModifier(compound, fluid, "");
        for (Map.Entry<String, DeliveryType.IGenerator> entry : deliveryTypes.entrySet()) {
            if (!(FluidUtil.getModifier(compound, fluid, entry.getKey()) > 0.0f)) continue;
            return entry.getValue();
        }
        return (gauntlet, elixir, user, fluid1) -> new DeliveryBlast(user, fluid1, 8.0, 3.0);
    }

    @Nullable
    public static CaskLiquid getFromFluid(FluidStack fluidStack) {
        if (fluidStack != null) {
            return CaskManager.getFromFluid(fluidStack.getFluid());
        }
        return null;
    }

    @Nullable
    public static CaskLiquid getFromFluid(Fluid fluid) {
        for (CaskLiquid liquid : liquids) {
            if (!liquid.fluid.equals(fluid)) continue;
            return liquid;
        }
        return null;
    }

    public static void register(String deliveryType, DeliveryType.IGenerator generator) {
        deliveryTypes.put(deliveryType, generator);
    }

    public static void register(CaskLiquid liquid) {
        liquids.add(liquid);
    }

    public static class CaskLiquid {
        public Fluid fluid;
        public int model;
        public int color;

        public CaskLiquid(Fluid fluid, int model, int color) {
            this.fluid = fluid;
            this.model = model;
            this.color = color;
        }

        public void applyEffects(World world, BlockPos pos, EnumFacing side, Entity source, Entity indirectsource, FluidStack fluid) {
        }

        public void applyEffects(EntityLivingBase target, Entity source, Entity indirectsource, FluidStack fluid) {
            ArrayList<CaskPotionEffect> effects = new ArrayList<CaskPotionEffect>();
            Fluid internal = fluid != null ? fluid.getFluid() : null;
            NBTTagCompound compound = FluidUtil.getModifiers(fluid);
            for (String key : FluidUtil.getModifierKeys(fluid)) {
                FluidModifier modifier = FluidUtil.MODIFIERS.get(key);
                if (modifier == null) continue;
                modifier.applyEffect(target, compound, internal);
                modifier.providePotionEffects(target, effects, compound, internal);
            }
            float duration_modifier = FluidUtil.getModifier(compound, internal, "duration");
            boolean concentrated = FluidUtil.getModifier(compound, internal, "concentration") >= 100.0f;
            boolean showParticles = FluidUtil.getModifier(compound, internal, "concentration") >= 50.0f;
            for (CaskPotionEffect effect : effects) {
                int concentration_bonus;
                PotionEffect potioneffect = effect.potionEffect;
                PotionEffect currentStack = target.func_70660_b(potioneffect.func_188419_a());
                int n = concentration_bonus = concentrated ? 1 : 0;
                if (potioneffect.func_188419_a().func_76403_b()) {
                    potioneffect.func_188419_a().func_180793_a(source, indirectsource, target, potioneffect.func_76458_c() + concentration_bonus, 1.0);
                    continue;
                }
                int amplifier = potioneffect.func_76458_c();
                int duration = (int)((float)potioneffect.func_76459_b() * duration_modifier);
                if (currentStack != null && (amplifier = Math.min(amplifier + currentStack.func_76458_c() + 1, effect.maxStack + concentration_bonus)) != currentStack.func_76458_c()) {
                    duration += currentStack.func_76459_b();
                }
                PotionEffect newStack = new PotionEffect(potioneffect.func_188419_a(), duration, amplifier, false, showParticles);
                target.func_70690_d(newStack);
            }
        }
    }

    public static class CaskPotionEffect {
        public PotionEffect potionEffect;
        public int maxStack;

        public CaskPotionEffect(PotionEffect effect, int maxStack) {
            this.potionEffect = effect;
            this.maxStack = maxStack;
        }
    }
}

