/*
 * Decompiled with CFR 0.152.
 */
package soot.brewing;

import net.minecraft.nbt.NBTTagCompound;
import soot.brewing.EssenceType;

public class EssenceStack {
    public static final EssenceStack EMPTY = new EssenceStack(null, 0);
    private EssenceType essence;
    private int amount;

    public EssenceStack(EssenceType essence, int amount) {
        this.essence = essence;
        this.amount = amount;
    }

    public EssenceStack(NBTTagCompound compound) {
        this.readFromNBT(compound);
    }

    public EssenceType getEssence() {
        if (this.isEmpty()) {
            return EssenceType.NULL;
        }
        return this.essence;
    }

    public int getAmount() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void shrink(int amount) {
        this.amount = Math.max(this.amount - amount, 0);
    }

    public void grow(int amount) {
        this.amount += amount;
    }

    public EssenceStack merge(EssenceStack other, int max) {
        int amount = Math.min(other.amount, max - this.amount);
        this.grow(amount);
        EssenceStack copy = other.copy();
        copy.shrink(amount);
        return copy;
    }

    public EssenceStack split(int amount) {
        amount = Math.min(amount, this.amount);
        EssenceStack copy = this.withSize(amount);
        this.shrink(amount);
        return copy;
    }

    public boolean isEmpty() {
        return this.essence == null || this.essence == EssenceType.NULL || this.amount <= 0;
    }

    private void readFromNBT(NBTTagCompound nbt) {
        this.essence = EssenceType.getType(nbt.func_74779_i("type"));
        this.amount = nbt.func_74762_e("amount");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("type", this.getEssence().getName());
        nbt.func_74768_a("amount", this.getAmount());
        return nbt;
    }

    public EssenceStack copy() {
        return new EssenceStack(this.essence, this.amount);
    }

    public EssenceStack withSize(int amount) {
        EssenceStack copy = this.copy();
        copy.setAmount(amount);
        return copy;
    }
}

