/*
 * Decompiled with CFR 0.152.
 */
package soot.brewing;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fluids.Fluid;
import soot.brewing.CaskManager;
import soot.brewing.EssenceStack;
import teamroots.embers.Embers;

public class FluidModifier {
    public String name;
    public float defaultValue;
    public boolean showAlways;
    public HashMap<Fluid, Float> defaultValues = new HashMap();
    public String formatType = "linear";
    public EnumType type;
    public EffectType effectType;

    public FluidModifier(String name, float defaultValue, EnumType type, EffectType effectType) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.type = type;
        this.effectType = effectType;
    }

    public FluidModifier setShowAlways() {
        this.showAlways = true;
        return this;
    }

    public FluidModifier setFormatType(String type) {
        this.formatType = type;
        return this;
    }

    public void applyEffect(EntityLivingBase target, NBTTagCompound compound, Fluid fluid) {
    }

    public void providePotionEffects(List<PotionEffect> effects, NBTTagCompound compound, Fluid fluid) {
    }

    public void providePotionEffects(EntityLivingBase target, ArrayList<CaskManager.CaskPotionEffect> effects, NBTTagCompound compound, Fluid fluid) {
    }

    public boolean isDefault(NBTTagCompound compound, Fluid fluid) {
        return this.getOrDefault(compound, fluid) == this.defaultValue;
    }

    public boolean hasDefault(Fluid fluid) {
        return this.defaultValues.containsKey(fluid);
    }

    public boolean has(NBTTagCompound compound, Fluid fluid) {
        return compound.func_150297_b(this.name, 99) || this.defaultValues.containsKey(fluid);
    }

    public float getOrDefault(NBTTagCompound compound, Fluid fluid) {
        if (compound.func_150297_b(this.name, 99)) {
            return compound.func_74760_g(this.name);
        }
        return this.defaultValues.containsKey(fluid) ? this.defaultValues.get(fluid).floatValue() : this.defaultValue;
    }

    public void set(NBTTagCompound compound, float value) {
        compound.func_74776_a(this.name, value);
    }

    public void setDefault(Fluid fluid, float value) {
        this.defaultValues.put(fluid, Float.valueOf(value));
    }

    public String getFormattedText(NBTTagCompound compound, Fluid fluid) {
        if (this.formatType == null) {
            return "";
        }
        float value = this.getOrDefault(compound, fluid);
        DecimalFormat format = Embers.proxy.getDecimalFormat("embers.decimal_format.distilling." + this.formatType);
        return I18n.func_135052_a((String)("distilling.modifier.dial." + this.formatType), (Object[])new Object[]{this.getLocalizedName(), format.format(value)});
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)("distilling.modifier." + this.name + ".name"), (Object[])new Object[0]);
    }

    public EssenceStack toEssence(float amount) {
        return EssenceStack.EMPTY;
    }

    public static enum EffectType {
        POSITIVE,
        NEGATIVE,
        NEUTRAL;

    }

    public static enum EnumType {
        PRIMARY,
        SECONDARY,
        TERTIARY;

    }
}

