/*
 * Decompiled with CFR 0.152.
 */
package soot.brewing;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fluids.Fluid;
import soot.brewing.CaskManager;
import soot.brewing.FluidModifier;

public class FluidPotionModifier
extends FluidModifier {
    Potion potion;
    int maxStack;

    public FluidPotionModifier(String name, float defaultValue, FluidModifier.EnumType type, FluidModifier.EffectType effectType, Potion potion, int maxStack) {
        super(name, defaultValue, type, effectType);
        this.potion = potion;
        this.maxStack = maxStack;
    }

    @Override
    public void providePotionEffects(EntityLivingBase target, ArrayList<CaskManager.CaskPotionEffect> effects, NBTTagCompound compound, Fluid fluid) {
        float value = this.getOrDefault(compound, fluid);
        effects.add(new CaskManager.CaskPotionEffect(new PotionEffect(this.potion, (int)value), this.maxStack));
    }

    @Override
    public void providePotionEffects(List<PotionEffect> effects, NBTTagCompound compound, Fluid fluid) {
        float value = this.getOrDefault(compound, fluid);
        effects.add(new PotionEffect(this.potion, (int)value));
    }
}

