/*
 * Decompiled with CFR 0.152.
 */
package soot.brewing.deliverytypes;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import soot.brewing.CaskManager;
import soot.brewing.DeliveryType;
import soot.network.PacketHandler;
import soot.network.message.MessageAlchemyBlastFX;
import soot.util.Attributes;
import teamroots.embers.util.FluidColorHelper;

public class DeliveryBlast
extends DeliveryType {
    double radius;
    double blastRadius;

    public DeliveryBlast(EntityLivingBase user, FluidStack fluidStack, double radius, double blastRadius) {
        super(user, fluidStack);
        this.radius = radius;
        this.blastRadius = blastRadius;
    }

    @Override
    public void apply(BlockPos pos, EnumFacing facing) {
        this.apply(this.user.func_70040_Z());
    }

    @Override
    public void apply(Vec3d dir) {
        World world = this.user.field_70170_p;
        Color mainColor = new Color(FluidColorHelper.getColor((FluidStack)this.fluidStack));
        AxisAlignedBB aabb = new AxisAlignedBB(this.user.func_180425_c());
        aabb = aabb.func_72314_b(this.radius, this.radius, this.radius);
        CaskManager.CaskLiquid liquid = CaskManager.getFromFluid(this.fluidStack);
        if (liquid != null) {
            for (Entity entity : world.func_175674_a((Entity)this.user, aabb, Attributes::isAttracted)) {
                AxisAlignedBB entityBox = entity.func_174813_aQ();
                Vec3d center = entityBox.func_189972_c();
                AxisAlignedBB blastBox = new AxisAlignedBB(center, center).func_186662_g(this.blastRadius);
                for (Entity blastEntity : world.func_175674_a((Entity)this.user, blastBox, e -> e instanceof EntityLivingBase)) {
                    liquid.applyEffects((EntityLivingBase)blastEntity, (Entity)this.user, (Entity)this.user, this.fluidStack);
                }
                PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageAlchemyBlastFX(center.field_72450_a, center.field_72448_b, center.field_72449_c, mainColor, mainColor, mainColor, (float)this.blastRadius, 10), entity);
                Attributes.resetAttraction(entity, 1);
            }
        }
    }
}

