/*
 * Decompiled with CFR 0.152.
 */
package soot.capability;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import teamroots.embers.tileentity.TileEntityMixerBottom;

public class CapabilityMixerOutput
implements IFluidHandler,
ICapabilityProvider {
    public static final ResourceLocation MIXER_OUTPUT = new ResourceLocation("soot", "mixer_output");
    TileEntityMixerBottom tile;
    IFluidTankProperties[] properties;

    public CapabilityMixerOutput(TileEntityMixerBottom tile) {
        this.tile = tile;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.properties == null) {
            ArrayList<IFluidTankProperties> importedProperties = new ArrayList<IFluidTankProperties>();
            if (this.tile != null) {
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    if (!this.tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) continue;
                    IFluidHandler capability = (IFluidHandler)this.tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
                    IFluidTankProperties[] faceProperties = capability.getTankProperties();
                    importedProperties.addAll(Arrays.asList(faceProperties));
                }
            }
            this.properties = importedProperties.toArray(new IFluidTankProperties[importedProperties.size()]);
        }
        return this.properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack drained = null;
        if (this.tile != null) {
            IFluidHandler capability;
            EnumFacing facing;
            EnumFacing[] enumFacingArray = EnumFacing.field_176754_o;
            int n = enumFacingArray.length;
            for (int i = 0; !(i >= n || this.tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing = enumFacingArray[i]) && (drained = (capability = (IFluidHandler)this.tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)).drain(resource, doDrain)) != null); ++i) {
            }
        }
        return drained;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = null;
        if (this.tile != null) {
            IFluidHandler capability;
            EnumFacing facing;
            EnumFacing[] enumFacingArray = EnumFacing.field_176754_o;
            int n = enumFacingArray.length;
            for (int i = 0; !(i >= n || this.tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing = enumFacingArray[i]) && (drained = (capability = (IFluidHandler)this.tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)).drain(maxDrain, doDrain)) != null); ++i) {
            }
        }
        return drained;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? this : null);
    }
}

