/*
 * Decompiled with CFR 0.152.
 */
package soot.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.potions.IPotion;
import crafttweaker.mc1120.CraftTweaker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import soot.brewing.EssenceStack;
import soot.brewing.FluidModifier;
import soot.brewing.FluidPotionModifier;
import soot.compat.crafttweaker.EssenceStackCT;
import soot.compat.crafttweaker.StillModifierBuilder;
import soot.recipe.CatalystInfo;
import soot.recipe.CraftingRegistry;
import soot.recipe.RecipeStill;
import soot.recipe.RecipeStillDoubleDistillation;
import soot.recipe.RecipeStillModifier;
import soot.recipe.RecipeStillModifierFood;
import soot.util.FluidUtil;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import teamroots.embers.compat.crafttweaker.CTUtil;

@ZenRegister
@ZenClass(value="mods.soot.Still")
public class Still {
    public static final String NAME = "Still";
    public static final String CLASS = "mods.soot.Still";

    private static List<Fluid> toFluids(IIngredient ingredient) {
        ArrayList<Fluid> rList = new ArrayList<Fluid>();
        for (ILiquidStack liquidStack : ingredient.getLiquids()) {
            rList.add(CraftTweakerMC.getFluid((ILiquidDefinition)liquidStack.getDefinition()));
        }
        return rList;
    }

    private static int toFluidConsumption(IIngredient ingredient) {
        return ingredient.getAmount();
    }

    private static List<EssenceStack> toEssenceList(EssenceStackCT[] essences) {
        ArrayList<EssenceStack> rList = new ArrayList<EssenceStack>();
        for (EssenceStackCT essence : essences) {
            rList.add(essence.getInternal());
        }
        return rList;
    }

    @ZenMethod
    public static void add(String id, ILiquidStack output, ILiquidStack input, IIngredient catalyst, int catalystConsumed, @Optional EssenceStackCT[] essences) {
        RecipeStill recipe = new RecipeStill(new ResourceLocation("crafttweaker", id), CraftTweakerMC.getLiquidStack((ILiquidStack)input), CTUtil.toIngredient((IIngredient)catalyst), catalystConsumed, CraftTweakerMC.getLiquidStack((ILiquidStack)output));
        if (essences != null) {
            recipe.setEssence(Still.toEssenceList(essences));
        }
        CraftTweaker.LATE_ACTIONS.add(new AddRecipe(recipe));
    }

    @ZenMethod
    public static StillModifierBuilder addModifierRecipe(String id, IIngredient input, IIngredient catalyst, int catalystConsumed, @Optional EssenceStackCT[] essences) {
        final int consumed = Still.toFluidConsumption(input);
        RecipeStillModifier recipe = new RecipeStillModifier(new ResourceLocation("crafttweaker", id), Still.toFluids(input), CTUtil.toIngredient((IIngredient)catalyst), catalystConsumed){

            @Override
            public int getInputConsumed() {
                return consumed;
            }
        };
        if (essences != null) {
            recipe.setEssence(Still.toEssenceList(essences));
        }
        CraftTweaker.LATE_ACTIONS.add(new AddRecipe(recipe));
        return new StillModifierBuilder(recipe);
    }

    @ZenMethod
    public static StillModifierBuilder addFoodRecipe(String id, IIngredient input, IIngredient catalyst, int catalystConsumed, int hunger, float saturation, @Optional EssenceStackCT[] essences) {
        final int consumed = Still.toFluidConsumption(input);
        RecipeStillModifierFood recipe = new RecipeStillModifierFood(new ResourceLocation("crafttweaker", id), Still.toFluids(input), CTUtil.toIngredient((IIngredient)catalyst), catalystConsumed, hunger, saturation){

            @Override
            public int getInputConsumed() {
                return consumed;
            }
        };
        if (essences != null) {
            recipe.setEssence(Still.toEssenceList(essences));
        }
        CraftTweaker.LATE_ACTIONS.add(new AddRecipe(recipe));
        return new StillModifierBuilder(recipe);
    }

    @ZenMethod
    public static StillModifierBuilder addDistillRecipe(String id, IIngredient input, IIngredient catalyst, int catalystConsumed, @Optional EssenceStackCT[] essences) {
        final int consumed = Still.toFluidConsumption(input);
        RecipeStillDoubleDistillation recipe = new RecipeStillDoubleDistillation(new ResourceLocation("crafttweaker", id), Still.toFluids(input), CTUtil.toIngredient((IIngredient)catalyst), catalystConsumed){

            @Override
            public int getInputConsumed() {
                return consumed;
            }
        };
        if (essences != null) {
            recipe.setEssence(Still.toEssenceList(essences));
        }
        CraftTweaker.LATE_ACTIONS.add(new AddRecipe(recipe));
        return new StillModifierBuilder(recipe);
    }

    @ZenMethod
    public static void addCatalyst(IIngredient ingredient, int size) {
        CatalystInfo info = new CatalystInfo(CTUtil.toIngredient((IIngredient)ingredient), size);
        CraftTweakerAPI.apply((IAction)new AddCatalyst(info));
    }

    @ZenMethod
    public static void addPotionModifier(String name, boolean primary, IPotion effect, int maxStack) {
        FluidModifier.EffectType effectType = Still.getEffectType(effect);
        FluidModifier.EnumType type = primary ? FluidModifier.EnumType.PRIMARY : FluidModifier.EnumType.SECONDARY;
        FluidPotionModifier modifier = new FluidPotionModifier(name, 0.0f, type, effectType, CraftTweakerMC.getPotion((IPotion)effect), maxStack);
        CraftTweakerAPI.apply((IAction)new AddModifier(modifier));
    }

    private static FluidModifier.EffectType getEffectType(IPotion effect) {
        boolean good = effect.isBeneficial();
        boolean bad = effect.isBadEffect();
        FluidModifier.EffectType effectType = FluidModifier.EffectType.NEUTRAL;
        if (good && !bad) {
            effectType = FluidModifier.EffectType.POSITIVE;
        } else if (bad && !good) {
            effectType = FluidModifier.EffectType.NEGATIVE;
        }
        return effectType;
    }

    @ZenMethod
    public static void remove(String id) {
        CraftTweakerAPI.apply((IAction)new RemoveByName(new ResourceLocation(id)));
    }

    public static class RemoveByName
    implements IAction {
        ResourceLocation id;

        public RemoveByName(ResourceLocation id) {
            this.id = id;
        }

        public void apply() {
            CraftingRegistry.stillRecipes.removeIf(recipe -> recipe.id.equals((Object)this.id));
        }

        public String describe() {
            return String.format("Removing %s recipe: %s", Still.NAME, this.id);
        }
    }

    public static class AddModifier
    implements IAction {
        FluidModifier modifier;

        public AddModifier(FluidModifier modifier) {
            this.modifier = modifier;
        }

        public void apply() {
            FluidUtil.registerModifier(this.modifier);
        }

        public String describe() {
            return String.format("Adding modifier: %s", this.modifier.toString());
        }
    }

    public static class AddCatalyst
    implements IAction {
        CatalystInfo catalystInfo;

        public AddCatalyst(CatalystInfo catalystInfo) {
            this.catalystInfo = catalystInfo;
        }

        public void apply() {
            CraftingRegistry.stillCatalysts.add(this.catalystInfo);
        }

        public String describe() {
            return String.format("Adding %s catalyst: %s", Still.NAME, this.catalystInfo.toString());
        }
    }

    public static class AddRecipe
    implements IAction {
        RecipeStill recipe;

        public AddRecipe(RecipeStill recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            CraftingRegistry.stillRecipes.add(this.recipe);
        }

        public String describe() {
            return String.format("Adding %s recipe: %s", Still.NAME, this.recipe.toString());
        }
    }
}

