/*
 * Decompiled with CFR 0.152.
 */
package soot.compat.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import soot.recipe.RecipeStillModifier;
import soot.recipe.breweffects.EffectAdd;
import soot.recipe.breweffects.EffectInfo;
import soot.recipe.breweffects.EffectLoss;
import soot.recipe.breweffects.EffectMax;
import soot.recipe.breweffects.EffectMin;
import soot.recipe.breweffects.EffectMultiply;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ReturnsSelf;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.soot.StillModifierBuilder")
@ZenRegister
public class StillModifierBuilder {
    RecipeStillModifier recipe;

    public StillModifierBuilder(RecipeStillModifier recipe) {
        this.recipe = recipe;
    }

    @ZenMethod
    @ReturnsSelf
    public StillModifierBuilder add(String modifier, float amount, @Optional boolean hidden) {
        this.recipe.addEffect(new EffectAdd(modifier, amount, hidden));
        return this;
    }

    @ZenMethod
    @ReturnsSelf
    public StillModifierBuilder add(String modifier, float amount, float limit, @Optional boolean hidden) {
        this.recipe.addEffect(new EffectAdd(modifier, amount, limit, hidden));
        return this;
    }

    @ZenMethod
    @ReturnsSelf
    public StillModifierBuilder multiply(String modifier, float multiplier, @Optional boolean hidden) {
        this.recipe.addEffect(new EffectMultiply(modifier, multiplier, hidden));
        return this;
    }

    @ZenMethod
    @ReturnsSelf
    public StillModifierBuilder multiply(String modifier, float multiplier, float min, float max, @Optional boolean hidden) {
        this.recipe.addEffect(new EffectMultiply(modifier, multiplier, min, max, hidden));
        return this;
    }

    @ZenMethod
    @ReturnsSelf
    public StillModifierBuilder gain(int output) {
        this.recipe.addEffect(new EffectLoss(this.recipe.getInputConsumed(), output));
        return this;
    }

    @ZenMethod
    @ReturnsSelf
    public StillModifierBuilder max(String modifier, float amount, @Optional boolean hidden) {
        this.recipe.addEffect(new EffectMax(modifier, amount, hidden));
        return this;
    }

    @ZenMethod
    @ReturnsSelf
    public StillModifierBuilder min(String modifier, float amount, @Optional boolean hidden) {
        this.recipe.addEffect(new EffectMin(modifier, amount, hidden));
        return this;
    }

    @ZenMethod
    @ReturnsSelf
    public StillModifierBuilder info(String modifier) {
        this.recipe.addEffect(new EffectInfo(modifier));
        return this;
    }

    @ZenMethod
    @ReturnsSelf
    public StillModifierBuilder info(String modifier, String format) {
        this.recipe.addEffect(new EffectInfo(modifier, format));
        return this;
    }
}

