/*
 * Decompiled with CFR 0.152.
 */
package soot.handler;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import soot.util.IMigrateable;

public class MigrationHandler {
    static HashMap<String, String> migratedBlocks = new HashMap();
    static HashMap<String, String> migratedItems = new HashMap();
    static HashSet<String> removedBlocks = Sets.newHashSet();
    static HashSet<String> removedItems = Sets.newHashSet();

    public MigrationHandler() {
        migratedItems.put("soot:metallurgic_dust", "embers:dust_metallurgic");
        migratedItems.put("soot:ember_grit", "embers:dust_ember");
        migratedItems.put("soot:catalytic_plug", "embers:catalytic_plug");
        migratedItems.put("soot:ember_funnel", "embers:ember_funnel");
        migratedBlocks.put("soot:catalytic_plug", "embers:catalytic_plug");
        migratedBlocks.put("soot:ember_funnel", "embers:ember_funnel");
    }

    @SubscribeEvent
    public void missingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            String path = entry.key.toString();
            if (migratedBlocks.containsKey(path)) {
                entry.remap((IForgeRegistryEntry)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(migratedBlocks.get(path))));
            }
            if (!removedBlocks.contains(path)) continue;
            entry.ignore();
        }
    }

    @SubscribeEvent
    public void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            String path = entry.key.toString();
            if (migratedItems.containsKey(path)) {
                entry.remap((IForgeRegistryEntry)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(migratedItems.get(path))));
            }
            if (!removedItems.contains(path)) continue;
            entry.ignore();
        }
    }

    @SubscribeEvent
    public void missingSoundMappings(RegistryEvent.MissingMappings<SoundEvent> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            if (!entry.key.func_110624_b().equals("soot")) continue;
            entry.ignore();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent.Post e) {
        IBlockState state;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        int w = e.getResolution().func_78326_a();
        int h = e.getResolution().func_78328_b();
        int x = w / 2;
        int y = h / 2;
        World world = player.func_130014_f_();
        RayTraceResult result = player.func_174822_a(6.0, e.getPartialTicks());
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(result.func_178782_a())).func_177230_c() instanceof IMigrateable) {
            String text = I18n.func_74838_a((String)"soot.tooltip.migrate");
            Minecraft.func_71410_x().field_71466_p.func_175063_a(text, (float)(x - Minecraft.func_71410_x().field_71466_p.func_78256_a(text) / 2), (float)(y + 40), 0xFFFFFF);
        }
        GlStateManager.func_179126_j();
    }
}

