/*
 * Decompiled with CFR 0.152.
 */
package soot.handler;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.InventoryMerchant;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import soot.Registry;

public class VillagerAntimonyHandler {
    private static Field buyingList;
    private static Field containerMerchant;
    private static HashMap<ContainerMerchant, ContainerWrapper> openContainers;
    private static ContainerWrapper clientContainer;

    public static ItemStack getCurrencyStack(ItemStack stack) {
        return stack.func_77973_b() == Registry.SIGNET_ANTIMONY ? new ItemStack(Items.field_151166_bC, stack.func_190916_E()) : stack;
    }

    public static IMerchant getContainerMerchant(ContainerMerchant container) {
        if (containerMerchant == null) {
            containerMerchant = ObfuscationReflectionHelper.findField(ContainerMerchant.class, (String)"field_75178_e");
        }
        IMerchant merchant = null;
        try {
            merchant = (IMerchant)containerMerchant.get(container);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return merchant;
    }

    public static void replaceTradeList(EntityVillager villager, MerchantRecipeList newlist) {
        if (buyingList == null) {
            buyingList = ObfuscationReflectionHelper.findField(EntityVillager.class, (String)"field_70963_i");
        }
        if (villager != null) {
            try {
                buyingList.set(villager, newlist);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean hasAntimony(MerchantRecipe recipe) {
        return recipe.func_77394_a().func_77973_b() == Registry.SIGNET_ANTIMONY || recipe.func_77396_b().func_77973_b() == Registry.SIGNET_ANTIMONY;
    }

    @Nullable
    private static MerchantRecipe getAntimonyEquivalent(MerchantRecipe recipe) {
        ItemStack firstItem = recipe.func_77394_a();
        ItemStack secondItem = recipe.func_77396_b();
        if (firstItem.func_77973_b() == Items.field_151166_bC || secondItem.func_77973_b() == Items.field_151166_bC) {
            if (firstItem.func_77973_b() == Items.field_151166_bC) {
                firstItem = new ItemStack(Registry.SIGNET_ANTIMONY, firstItem.func_190916_E());
            }
            if (secondItem.func_77973_b() == Items.field_151166_bC) {
                secondItem = new ItemStack(Registry.SIGNET_ANTIMONY, secondItem.func_190916_E());
            }
            return new MerchantRecipe(firstItem, secondItem, recipe.func_77397_d(), recipe.func_180321_e(), recipe.func_180320_f());
        }
        return recipe;
    }

    @SubscribeEvent
    public static void onContainerOpen(PlayerContainerEvent.Open event) {
        Container container = event.getContainer();
        if (container instanceof ContainerMerchant && !openContainers.containsKey(container)) {
            openContainers.put((ContainerMerchant)container, new ContainerWrapper((ContainerMerchant)container));
        }
    }

    @SubscribeEvent
    public static void onContainerClose(PlayerContainerEvent.Close event) {
        Container container = event.getContainer();
        if (container instanceof ContainerMerchant && openContainers.containsKey(container)) {
            openContainers.get(container).resetList();
            openContainers.remove(container);
        }
    }

    @SubscribeEvent
    public static void onUpdate(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            openContainers.values().forEach(ContainerWrapper::update);
        }
    }

    @SubscribeEvent
    public static void onClientUpdate(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui instanceof GuiMerchant) {
                ContainerMerchant container = (ContainerMerchant)((GuiMerchant)gui).field_147002_h;
                if (container != null && (clientContainer == null || VillagerAntimonyHandler.clientContainer.container != container)) {
                    clientContainer = new ContainerWrapper(container);
                }
                clientContainer.update();
            } else {
                clientContainer = null;
            }
        }
    }

    static {
        openContainers = new HashMap();
    }

    private static class ContainerWrapper {
        ContainerMerchant container;
        MerchantRecipeList defaultList;
        MerchantRecipeList replacedList;
        IMerchant merchant;
        boolean dirty;

        public ContainerWrapper(ContainerMerchant container) {
            this.container = container;
            this.merchant = VillagerAntimonyHandler.getContainerMerchant(container);
        }

        public void update() {
            if (this.merchant.func_70931_l_() == null) {
                return;
            }
            InventoryMerchant inventory = this.container.func_75174_d();
            ItemStack firstStack = inventory.func_70301_a(0);
            ItemStack secondStack = inventory.func_70301_a(1);
            MerchantRecipeList currentList = this.merchant.func_70934_b(this.merchant.func_70931_l_());
            if (currentList != this.replacedList && currentList != this.defaultList) {
                this.defaultList = currentList;
                this.dirty = true;
            }
            if (firstStack.func_77973_b() == Registry.SIGNET_ANTIMONY || secondStack.func_77973_b() == Registry.SIGNET_ANTIMONY) {
                if (this.dirty) {
                    this.replacedList = this.generateReplacement(this.defaultList);
                    this.dirty = false;
                }
                if (currentList != this.replacedList) {
                    this.replaceList(this.merchant, this.replacedList);
                    this.container.func_75174_d().func_70470_g();
                }
            } else if (currentList != this.defaultList) {
                this.replaceList(this.merchant, this.defaultList);
                this.container.func_75174_d().func_70470_g();
            }
        }

        public void resetList() {
            if (this.defaultList != null) {
                this.replaceList(this.merchant, this.defaultList);
            }
        }

        public MerchantRecipeList generateReplacement(MerchantRecipeList original) {
            return original.stream().map(x$0 -> VillagerAntimonyHandler.getAntimonyEquivalent(x$0)).collect(Collectors.toCollection(MerchantRecipeList::new));
        }

        public void replaceList(IMerchant merchant, MerchantRecipeList list) {
            if (merchant instanceof EntityVillager) {
                VillagerAntimonyHandler.replaceTradeList((EntityVillager)merchant, list);
            } else if (merchant.func_190670_t_().field_72995_K) {
                merchant.func_70930_a(list);
            }
        }
    }
}

