/*
 * Decompiled with CFR 0.152.
 */
package soot.item;

import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import soot.brewing.CaskManager;
import soot.brewing.DeliveryType;
import soot.util.MiscUtil;
import teamroots.embers.EventManager;
import teamroots.embers.util.FluidColorHelper;

public class ItemElixir
extends Item {
    public static final int CAPACITY = 200;

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, this.getCapacity(stack));
    }

    public FluidStack getFluid(ItemStack stack) {
        return FluidUtil.getFluidContained((ItemStack)stack);
    }

    private boolean hasFluid(ItemStack stack) {
        return this.getFluid(stack) != null;
    }

    public int getCapacity(ItemStack stack) {
        return 200;
    }

    public Color getGlowColor(ItemStack stack) {
        Color secondColor;
        Color firstColor = this.getColor(stack);
        if (firstColor != null) {
            secondColor = MiscUtil.maxColor(firstColor);
        } else {
            firstColor = Color.MAGENTA;
            secondColor = Color.BLACK;
        }
        double glow = 0.5 + 0.5 * Math.sin((double)EventManager.ticks * Math.PI * 2.0 / 100.0);
        return MiscUtil.lerpColor(firstColor, secondColor, glow);
    }

    public Color getColor(ItemStack stack) {
        FluidStack fluid = this.getFluid(stack);
        return fluid != null ? new Color(FluidColorHelper.getColor((FluidStack)fluid)) : null;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public DeliveryType getDeliveryType(ItemStack gauntlet, ItemStack elixir, EntityLivingBase player) {
        FluidStack fluid = this.getFluid(elixir);
        DeliveryType.IGenerator generator = CaskManager.getDeliveryType(fluid);
        return generator.generate(gauntlet, elixir, player, fluid);
    }

    public void activateBlock(ItemStack gauntlet, ItemStack elixir, EntityLivingBase player, EnumHand hand, BlockPos pos, EnumFacing facing) {
        DeliveryType deliveryType = this.getDeliveryType(gauntlet, elixir, player);
        deliveryType.apply(pos, facing);
    }

    public void activate(ItemStack gauntlet, ItemStack elixir, EntityLivingBase player, EnumHand hand, Vec3d dir) {
        DeliveryType deliveryType = this.getDeliveryType(gauntlet, elixir, player);
        deliveryType.apply(dir);
    }

    public ItemStack getEmpty() {
        return new ItemStack((Item)this);
    }

    public ItemStack getFilled(FluidStack fluid) {
        ItemStack filled = new ItemStack((Item)this);
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)filled);
        if (handler != null) {
            handler.fill(fluid, true);
            return handler.getContainer();
        }
        return ItemStack.field_190927_a;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return this.getGlowColor(stack).getRGB();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.hasFluid(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 0.0;
    }
}

