/*
 * Decompiled with CFR 0.152.
 */
package soot.item;

import java.awt.Color;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import soot.brewing.EssenceStack;
import soot.brewing.EssenceType;
import soot.item.IEssenceContainer;
import soot.util.IItemColored;

public class ItemEssence
extends Item
implements IItemColored,
IEssenceContainer {
    public static final int CAPACITY = 1000;

    public ItemStack getStack(EssenceType type) {
        return this.getStack(type, 1);
    }

    public ItemStack getStack(EssenceType type, int n) {
        ItemStack stack = new ItemStack((Item)this, n);
        stack.func_77983_a("type", (NBTBase)new NBTTagString(type.getName()));
        return stack;
    }

    public static EssenceType getType(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            return EssenceType.getType(compound.func_74779_i("type"));
        }
        return EssenceType.NULL;
    }

    @Override
    public EssenceStack getEssence(ItemStack stack) {
        return new EssenceStack(ItemEssence.getType(stack), 1000);
    }

    @Override
    public int getCapacity(ItemStack stack) {
        return 1000;
    }

    @Override
    public ItemStack addEssence(ItemStack stack, EssenceStack essence) {
        return this.getStack(essence.getEssence());
    }

    @Override
    public ItemStack removeEssence(ItemStack stack, EssenceStack essence) {
        return this.getStack(EssenceType.NULL);
    }

    public ItemEssence() {
        this.func_77627_a(true);
    }

    public String func_77653_i(ItemStack stack) {
        EssenceType type = ItemEssence.getType(stack);
        String essenceName = I18n.func_74838_a((String)("distilling.essence." + type.getName() + ".name"));
        return I18n.func_74837_a((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[]{essenceName}).trim();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (EssenceType type : EssenceType.getAllTypes()) {
                items.add((Object)this.getStack(type));
            }
        }
    }

    @Override
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        EssenceType type = ItemEssence.getType(stack);
        if (tintIndex == 0) {
            return type.getFillColor().getRGB();
        }
        if (tintIndex == 1) {
            return type.getOverlayColor().getRGB();
        }
        return Color.WHITE.getRGB();
    }
}

