/*
 * Decompiled with CFR 0.152.
 */
package soot.itemmod;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import soot.Registry;
import soot.handler.WitchburnHandler;
import soot.itemmod.EffectWitchburn;
import teamroots.embers.api.event.EmberProjectileEvent;
import teamroots.embers.api.event.ItemVisualEvent;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.api.itemmod.ModifierProjectileBase;
import teamroots.embers.api.projectile.EffectArea;
import teamroots.embers.api.projectile.EffectDamage;
import teamroots.embers.api.projectile.EffectMulti;
import teamroots.embers.api.projectile.IProjectileEffect;
import teamroots.embers.api.projectile.IProjectilePreset;

public class ModifierWitchburn
extends ModifierProjectileBase {
    public ModifierWitchburn() {
        super("witchburn", 8.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onProjectileFire(EmberProjectileEvent event) {
        int level;
        ListIterator projectiles = event.getProjectiles().listIterator();
        ItemStack weapon = event.getStack();
        if (!weapon.func_190926_b() && ItemModUtil.hasHeat((ItemStack)weapon) && (level = ItemModUtil.getModifierLevel((ItemStack)weapon, (ModifierBase)Registry.WITCHBURN)) > 0) {
            while (projectiles.hasNext()) {
                IProjectilePreset projectile = (IProjectilePreset)projectiles.next();
                projectile.setColor(WitchburnHandler.COLOR);
                projectile.setEffect(this.adjustEffect(projectile.getEffect(), level));
            }
        }
    }

    @SubscribeEvent
    public void onItemEffect(ItemVisualEvent event) {
        int level;
        ItemStack stack = event.getItem();
        if (!stack.func_190926_b() && ItemModUtil.hasHeat((ItemStack)stack) && (level = ItemModUtil.getModifierLevel((ItemStack)stack, (ModifierBase)Registry.WITCHBURN)) > 0) {
            event.setColor(WitchburnHandler.COLOR);
        }
    }

    private IProjectileEffect adjustEffect(IProjectileEffect effect, int level) {
        if (effect instanceof EffectArea) {
            EffectArea areaEffect = (EffectArea)effect;
            areaEffect.setEffect(this.adjustEffect(areaEffect.getEffect(), level));
            return areaEffect;
        }
        if (effect instanceof EffectMulti) {
            ((EffectMulti)effect).addEffect((IProjectileEffect)new EffectWitchburn(100 * level));
            return effect;
        }
        if (effect instanceof EffectDamage) {
            ((EffectDamage)effect).setFire(0);
        }
        EffectMulti multiEffect = new EffectMulti((List)Lists.newArrayList((Object[])new IProjectileEffect[]{effect}));
        return this.adjustEffect((IProjectileEffect)multiEffect, level);
    }
}

