/*
 * Decompiled with CFR 0.152.
 */
package soot.network.message;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import soot.particle.ParticleUtilSoot;

public class MessageAlchemyBlastFX
implements IMessage {
    double x;
    double y;
    double z;
    Color mainColor;
    Color backColor;
    Color cubeColor;
    float scale;
    int lifetime;

    public MessageAlchemyBlastFX() {
    }

    public MessageAlchemyBlastFX(double x, double y, double z, Color mainColor, Color backColor, Color cubeColor, float scale, int lifetime) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.mainColor = mainColor;
        this.backColor = backColor;
        this.cubeColor = cubeColor;
        this.scale = scale;
        this.lifetime = lifetime;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.mainColor = new Color(buf.readInt(), true);
        this.backColor = new Color(buf.readInt(), true);
        this.cubeColor = new Color(buf.readInt(), true);
        this.scale = buf.readFloat();
        this.lifetime = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.mainColor.getRGB());
        buf.writeInt(this.backColor.getRGB());
        buf.writeInt(this.cubeColor.getRGB());
        buf.writeFloat(this.scale);
        buf.writeInt(this.lifetime);
    }

    public static class MessageHolder
    implements IMessageHandler<MessageAlchemyBlastFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageAlchemyBlastFX message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                ParticleUtilSoot.spawnAlchemyExplosion((World)world, message.x, message.y, message.z, message.mainColor, message.backColor, message.cubeColor, message.scale, message.lifetime);
            });
            return null;
        }
    }
}

