/*
 * Decompiled with CFR 0.152.
 */
package soot.network.message;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import soot.particle.ParticleUtilSoot;
import teamroots.embers.particle.ParticleUtil;

public class MessageMixerBlastFX
implements IMessage {
    double x;
    double y;
    double z;
    int lightning;
    double radius;

    public MessageMixerBlastFX() {
    }

    public MessageMixerBlastFX(double x, double y, double z, int lightning, double radius) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.lightning = lightning;
        this.radius = radius;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.lightning = buf.readInt();
        this.radius = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.lightning);
        buf.writeDouble(this.radius);
    }

    public static class MessageHolder
    implements IMessageHandler<MessageMixerBlastFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageMixerBlastFX message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                float dz;
                float dy;
                float dx;
                double pitch;
                double yaw;
                int i;
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                Random random = world.field_73012_v;
                Color color = new Color(181, 90, 255);
                float ox = (float)message.x;
                float oy = (float)message.y;
                float oz = (float)message.z;
                for (i = 0; i < 120; ++i) {
                    yaw = (double)random.nextFloat() * Math.PI * 2.0;
                    pitch = (double)random.nextFloat() * Math.PI * 2.0;
                    dx = (float)(Math.sin(yaw) * Math.cos(pitch));
                    dy = (float)Math.sin(pitch);
                    dz = (float)(Math.cos(yaw) * Math.cos(pitch));
                    int lifetime = 20;
                    float dist = (float)message.radius;
                    ParticleUtil.spawnParticleSpark((World)world, (float)ox, (float)oy, (float)oz, (float)(dx * dist / (float)lifetime), (float)(dy * dist / (float)lifetime), (float)(dz * dist / (float)lifetime), (float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)2.0f, (int)lifetime);
                }
                for (i = 0; i < message.lightning; ++i) {
                    yaw = (double)random.nextFloat() * Math.PI * 2.0;
                    pitch = (double)random.nextFloat() * Math.PI * 2.0;
                    dx = (float)(Math.sin(yaw) * Math.cos(pitch));
                    dy = (float)Math.sin(pitch);
                    dz = (float)(Math.cos(yaw) * Math.cos(pitch));
                    double dist = 16.0;
                    double sx = (double)ox + (double)dx * 0.6;
                    double sy = (double)oy + (double)dy * 0.6;
                    double sz = (double)oz + (double)dz * 0.6;
                    if (world.func_184143_b(new AxisAlignedBB(sx, sy, sz, sx, sy, sz))) continue;
                    double ex = (double)ox + (double)dx * dist;
                    double ey = (double)oy + (double)dy * dist;
                    double ez = (double)oz + (double)dz * dist;
                    RayTraceResult raytraceresult = world.func_147447_a(new Vec3d(sx, sy, sz), new Vec3d(ex, ey, ez), true, true, false);
                    if (raytraceresult != null && raytraceresult.field_72307_f != null) {
                        ex = raytraceresult.field_72307_f.field_72450_a;
                        ey = raytraceresult.field_72307_f.field_72448_b;
                        ez = raytraceresult.field_72307_f.field_72449_c;
                    }
                    ParticleUtilSoot.spawnLightning((World)world, ox, oy, oz, ex, ey, ez, 16, 1.0, color, 2.5, 30);
                }
            });
            return null;
        }
    }
}

