/*
 * Decompiled with CFR 0.152.
 */
package soot.particle;

import java.awt.Color;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import soot.particle.ParticleCube;

public class ParticleCrystal
extends ParticleCube {
    public static final ResourceLocation texture = new ResourceLocation("soot", "entity/particle_dawnstone");
    Entity anchor;

    public ParticleCrystal(Entity anchor, double x, double y, double z, double vx, double vy, double vz, float yaw, float pitch, Color color, float scale, int lifetime) {
        super(anchor.field_70170_p, x, y, z, vx, vy, vz, color, scale, lifetime);
        this.anchor = anchor;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    @Override
    public int func_70537_b() {
        return 1;
    }

    @Override
    public void func_189213_a() {
        if (this.anchor == null || !this.anchor.func_70089_S() || this.anchor.field_70170_p != this.field_187122_b) {
            this.func_187112_i();
            return;
        }
        super.func_189213_a();
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
    }

    @Override
    public boolean alive() {
        return this.anchor != null && this.anchor.func_70089_S() && this.anchor.field_70170_p == this.field_187122_b && this.field_70546_d < this.field_70547_e;
    }

    @Override
    public boolean isAdditive() {
        return true;
    }

    @Override
    public boolean renderThroughBlocks() {
        return false;
    }

    @Override
    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float minU = this.field_187119_C.func_94209_e();
        float maxU = this.field_187119_C.func_94212_f();
        float minV = this.field_187119_C.func_94206_g();
        float maxV = this.field_187119_C.func_94210_h();
        double lifeCoeff = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        float scale = 0.1f * (float)MathHelper.func_151238_b((double)this.scaleEnd, (double)this.scaleStart, (double)Math.sin(lifeCoeff * Math.PI));
        scale = (float)Math.sqrt(scale);
        float yaw = this.yaw + (this.yaw - this.prevYaw) * partialTicks;
        float pitch = this.pitch + (this.pitch - this.prevPitch) * partialTicks;
        double ex = this.anchor.field_70142_S * (double)(1.0f - partialTicks) + this.anchor.field_70165_t * (double)partialTicks;
        double ey = this.anchor.field_70137_T * (double)(1.0f - partialTicks) + this.anchor.field_70163_u * (double)partialTicks;
        double ez = this.anchor.field_70136_U * (double)(1.0f - partialTicks) + this.anchor.field_70161_v * (double)partialTicks;
        float x = (float)(ex + this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float y = (float)(ey + this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float z = (float)(ez + this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        double sina = Math.sin(yaw);
        double cosa = Math.cos(yaw);
        double sinb = Math.sin(pitch);
        double cosb = Math.cos(pitch);
        Vec3d forward = new Vec3d(cosb, 0.0, sinb);
        Vec3d up = new Vec3d(sina * sinb, cosa, -sina * cosb);
        Vec3d right = new Vec3d(-cosa * sinb, sina, cosa * cosb);
        int lightmap = this.func_189214_a(partialTicks);
        double length = scale * 8.0f;
        Vec3d[] points = new Vec3d[]{new Vec3d((double)(-scale), (double)(-scale), 0.0), new Vec3d((double)(-scale), (double)(-scale), length), new Vec3d((double)(-scale), (double)scale, 0.0), new Vec3d((double)(-scale), (double)scale, length), new Vec3d((double)scale, (double)(-scale), 0.0), new Vec3d((double)scale, (double)(-scale), length), new Vec3d((double)scale, (double)scale, 0.0), new Vec3d((double)scale, (double)scale, length)};
        for (int i = 0; i < points.length; ++i) {
            Vec3d v = points[i];
            points[i] = v.func_178789_a(pitch).func_178785_b(yaw).func_72441_c((double)x, (double)y, (double)z);
        }
        ParticleCrystal.addBox(buffer, points[0], points[1], points[2], points[3], points[4], points[5], points[6], points[7], new Color(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as), lightmap, minU, minV, maxU, maxV);
    }

    private static void addBox(BufferBuilder buffer, Vec3d a, Vec3d b, Vec3d c, Vec3d d, Vec3d e, Vec3d f, Vec3d g, Vec3d h, Color color, int lightmap, double minu, double minv, double maxu, double maxv) {
        int j = lightmap >> 16 & 0xFFFF;
        int k = lightmap & 0xFFFF;
        buffer.func_181662_b(a.field_72450_a, a.field_72448_b, a.field_72449_c).func_187315_a(minu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(b.field_72450_a, b.field_72448_b, b.field_72449_c).func_187315_a(maxu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(f.field_72450_a, f.field_72448_b, f.field_72449_c).func_187315_a(maxu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(e.field_72450_a, e.field_72448_b, e.field_72449_c).func_187315_a(minu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(c.field_72450_a, c.field_72448_b, c.field_72449_c).func_187315_a(minu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(d.field_72450_a, d.field_72448_b, d.field_72449_c).func_187315_a(maxu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(h.field_72450_a, h.field_72448_b, h.field_72449_c).func_187315_a(maxu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(g.field_72450_a, g.field_72448_b, g.field_72449_c).func_187315_a(minu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(a.field_72450_a, a.field_72448_b, a.field_72449_c).func_187315_a(minu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(e.field_72450_a, e.field_72448_b, e.field_72449_c).func_187315_a(maxu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(g.field_72450_a, g.field_72448_b, g.field_72449_c).func_187315_a(maxu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(c.field_72450_a, c.field_72448_b, c.field_72449_c).func_187315_a(minu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(b.field_72450_a, b.field_72448_b, b.field_72449_c).func_187315_a(minu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(f.field_72450_a, f.field_72448_b, f.field_72449_c).func_187315_a(maxu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(h.field_72450_a, h.field_72448_b, h.field_72449_c).func_187315_a(maxu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(d.field_72450_a, d.field_72448_b, d.field_72449_c).func_187315_a(minu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(a.field_72450_a, a.field_72448_b, a.field_72449_c).func_187315_a(minu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(b.field_72450_a, b.field_72448_b, b.field_72449_c).func_187315_a(maxu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(d.field_72450_a, d.field_72448_b, d.field_72449_c).func_187315_a(maxu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(c.field_72450_a, c.field_72448_b, c.field_72449_c).func_187315_a(minu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(e.field_72450_a, e.field_72448_b, e.field_72449_c).func_187315_a(minu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(f.field_72450_a, f.field_72448_b, f.field_72449_c).func_187315_a(maxu, minv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(h.field_72450_a, h.field_72448_b, h.field_72449_c).func_187315_a(maxu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(g.field_72450_a, g.field_72448_b, g.field_72449_c).func_187315_a(minu, maxv).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_187314_a(j, k).func_181675_d();
    }
}

