/*
 * Decompiled with CFR 0.152.
 */
package soot.potion;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import soot.Registry;
import soot.entity.EntityFireCloud;
import soot.potion.PotionBase;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.util.ItemUtil;

public class PotionFireLung
extends PotionBase {
    public PotionFireLung() {
        super(false, new Color(152, 93, 63).getRGB());
        this.func_76390_b("effect.fire_lung");
        this.func_76399_b(3, 0);
        this.func_188413_j();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_76394_a(EntityLivingBase living, int amplifier) {
        PotionEffect effect = living.func_70660_b((Potion)this);
        if (effect != null && effect.func_76459_b() == 1) {
            living.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 1000));
        }
        super.func_76394_a(living, amplifier);
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickItem event) {
        World world = event.getWorld();
        EntityLivingBase living = event.getEntityLiving();
        ItemStack stack = event.getItemStack();
        PotionEffect effect = living.func_70660_b((Potion)this);
        if (ItemUtil.matchesOreDict((ItemStack)stack, (String)"torch") && effect != null) {
            Vec3d hitPos = PotionFireLung.rayTrace(living.field_70170_p, living, true);
            if (!world.field_72995_K) {
                EntityFireCloud cloud = new EntityFireCloud(world, hitPos.field_72450_a, hitPos.field_72448_b, hitPos.field_72449_c);
                cloud.setDuration(200);
                cloud.setRadius(2.0f);
                cloud.setOwner(living);
                cloud.setColor(-49136);
                cloud.func_82142_c(true);
                world.func_72838_d((Entity)cloud);
            } else {
                Vec3d eyePos = living.func_174824_e(1.0f);
                Vec3d vel = hitPos.func_178788_d(eyePos).func_186678_a(0.003);
                ParticleUtil.spawnParticleGlow((World)world, (float)((float)eyePos.field_72450_a), (float)((float)eyePos.field_72448_b), (float)((float)eyePos.field_72449_c), (float)((float)vel.field_72450_a), (float)((float)vel.field_72448_b), (float)((float)vel.field_72450_a), (float)255.0f, (float)64.0f, (float)16.0f, (float)255.0f, (float)2.0f, (int)50);
            }
            if (effect.func_76459_b() > 10) {
                PotionEffect reducedEffect = new PotionEffect(Registry.POTION_FIRE_LUNG, effect.func_76459_b() - 5, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e());
                reducedEffect.setCurativeItems(effect.getCurativeItems());
                living.func_70690_d(reducedEffect);
            } else {
                living.func_184589_d(Registry.POTION_FIRE_LUNG);
            }
            event.setCanceled(true);
        }
    }

    private static Vec3d rayTrace(World worldIn, EntityLivingBase playerIn, boolean useLiquids) {
        float pitch = playerIn.field_70125_A;
        float yaw = playerIn.field_70177_z;
        double xPos = playerIn.field_70165_t;
        double yPos = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double zPos = playerIn.field_70161_v;
        Vec3d startPos = new Vec3d(xPos, yPos, zPos);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double distance = 5.0;
        if (playerIn instanceof EntityPlayerMP) {
            distance = ((EntityPlayerMP)playerIn).field_71134_c.getBlockReachDistance();
        }
        Vec3d endPos = startPos.func_72441_c((double)f6 * distance, (double)f5 * distance, (double)f7 * distance);
        RayTraceResult result = worldIn.func_147447_a(startPos, endPos, useLiquids, !useLiquids, false);
        return result != null ? result.field_72307_f : endPos;
    }
}

