/*
 * Decompiled with CFR 0.152.
 */
package soot.potion;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import soot.potion.PotionBase;
import soot.util.Attributes;
import teamroots.embers.EventManager;

public class PotionTipsy
extends PotionBase {
    Field handDropChances;

    public PotionTipsy() {
        super(true, new Color(90, 70, 20).getRGB());
        this.func_76390_b("effect.tipsy");
        this.func_76399_b(1, 1);
        this.func_111184_a(SharedMonsterAttributes.field_111266_c, "ba230016-5662-419c-a577-bd14d3f4a551", 0.4, 2);
        this.func_111184_a(Attributes.BAREHANDED_POWER, "89a374d8-f058-4bc8-840f-a3a89ea1f904", 0.4, 2);
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    private void turnEntity(Entity entity, float angle) {
        entity.field_70177_z += angle;
        if (entity.func_184187_bx() != null) {
            entity.func_184187_bx().func_184190_l(entity);
        }
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        Random random = entity.func_70681_au();
        PotionEffect effect = entity.func_70660_b((Potion)this);
        if (entity instanceof EntityPlayer == entity.field_70170_p.field_72995_K) {
            double dx = entity.field_70159_w;
            double dy = entity.field_70181_x;
            double dz = entity.field_70179_y;
            float speed = (float)MathHelper.func_151237_a((double)Math.sqrt(dx * dx + dz * dz), (double)0.2, (double)1.0);
            if (speed != 0.0f) {
                this.turnEntity((Entity)entity, (float)Math.sin((double)EventManager.ticks / 30.0) * 4.0f * speed * (float)(amplifier + 1));
            }
        }
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (effect != null && effect.func_76459_b() % 10 == 0) {
            if (this.handDropChances == null) {
                this.handDropChances = ObfuscationReflectionHelper.findField(EntityLiving.class, (String)"field_82174_bp");
            }
            if (random.nextInt(100) < amplifier) {
                boolean canDropMain = true;
                boolean canDropOffhand = true;
                if (entity instanceof EntityLiving) {
                    try {
                        float[] chances = (float[])this.handDropChances.get(entity);
                        canDropMain = chances[EntityEquipmentSlot.MAINHAND.func_188454_b()] > 0.0f;
                        canDropOffhand = chances[EntityEquipmentSlot.OFFHAND.func_188454_b()] > 0.0f;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                if (random.nextBoolean() && canDropMain) {
                    this.dropItem(entity, EntityEquipmentSlot.MAINHAND);
                } else if (canDropOffhand) {
                    this.dropItem(entity, EntityEquipmentSlot.OFFHAND);
                }
            }
        }
    }

    public void dropItem(EntityLivingBase entity, EntityEquipmentSlot slot) {
        ItemStack droppedItem = entity.func_184582_a(slot);
        entity.func_184201_a(slot, ItemStack.field_190927_a);
        double d0 = entity.field_70163_u - (double)0.3f + (double)entity.func_70047_e();
        EntityItem entityitem = new EntityItem(entity.field_70170_p, entity.field_70165_t, d0, entity.field_70161_v, droppedItem);
        entityitem.func_174867_a(40);
        entityitem.func_145799_b(entity.func_70005_c_());
        float f2 = 0.3f;
        entityitem.field_70159_w = -MathHelper.func_76126_a((float)(entity.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(entity.field_70125_A * ((float)Math.PI / 180))) * f2;
        entityitem.field_70179_y = MathHelper.func_76134_b((float)(entity.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(entity.field_70125_A * ((float)Math.PI / 180))) * f2;
        entityitem.field_70181_x = -MathHelper.func_76126_a((float)(entity.field_70125_A * ((float)Math.PI / 180))) * f2 + 0.1f;
        Random rng = entity.func_70681_au();
        float f3 = rng.nextFloat() * ((float)Math.PI * 2);
        f2 = 0.02f * rng.nextFloat();
        entityitem.field_70159_w += Math.cos(f3) * (double)f2;
        entityitem.field_70181_x += (double)((rng.nextFloat() - rng.nextFloat()) * 0.1f);
        entityitem.field_70179_y += Math.sin(f3) * (double)f2;
        entity.field_70170_p.func_72838_d((Entity)entityitem);
    }
}

