/*
 * Decompiled with CFR 0.152.
 */
package soot.projectiles;

import java.awt.Color;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import soot.network.PacketHandler;
import soot.network.message.MessageFireBlastFX;
import teamroots.embers.api.projectile.IProjectileEffect;
import teamroots.embers.api.projectile.IProjectilePreset;

public class ProjectileFireBlast
implements IProjectilePreset {
    static ArrayList<Active> activeBlasts = new ArrayList();
    Vec3d pos;
    Vec3d velocity;
    IProjectileEffect effect;
    Entity shooter;
    Color color;
    double counterLifetime;
    int counter;
    double radius;

    @SubscribeEvent
    public static void updateBlasts(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.side != Side.SERVER) {
            return;
        }
        ListIterator<Active> iterator = activeBlasts.listIterator();
        while (iterator.hasNext()) {
            Active blast = iterator.next();
            if (blast.world == event.world) {
                blast.update();
            }
            if (blast.isAlive()) continue;
            iterator.remove();
        }
    }

    public ProjectileFireBlast(Entity shooter, Vec3d start, Vec3d stop, IProjectileEffect effect, Color color, int times, int lifetime, double radius) {
        this.shooter = shooter;
        this.pos = start;
        this.velocity = stop.func_178788_d(start).func_186678_a(1.0 / (double)lifetime);
        this.effect = effect;
        this.color = color;
        this.counter = times;
        this.counterLifetime = (double)lifetime / (double)times;
        this.radius = radius;
    }

    public Vec3d getPos() {
        return this.pos;
    }

    public Vec3d getVelocity() {
        return this.velocity;
    }

    public Color getColor() {
        return this.color;
    }

    public IProjectileEffect getEffect() {
        return this.effect;
    }

    @Nullable
    public Entity getEntity() {
        return null;
    }

    @Nullable
    public Entity getShooter() {
        return this.shooter;
    }

    public void setPos(Vec3d pos) {
        this.pos = pos;
    }

    public void setVelocity(Vec3d velocity) {
        this.velocity = velocity;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setEffect(IProjectileEffect effect) {
        this.effect = effect;
    }

    public void shoot(World world) {
        if (!world.field_72995_K) {
            activeBlasts.add(new Active(world, this));
        }
    }

    static class Active {
        public World world;
        public ProjectileFireBlast preset;
        public int ticks;
        public double counterTicks;
        public int counter;

        public Active(World world, ProjectileFireBlast preset) {
            this.world = world;
            this.preset = preset;
            this.counterTicks = preset.counterLifetime;
        }

        public void update() {
            ++this.ticks;
            this.counterTicks += 1.0;
            if (this.counterTicks > this.preset.counterLifetime) {
                ++this.counter;
                this.counterTicks %= 1.0;
                this.emit();
            }
        }

        public void emit() {
            Vec3d pos = this.preset.pos.func_72441_c(this.preset.velocity.field_72450_a * (double)this.ticks, this.preset.velocity.field_72448_b * (double)this.ticks, this.preset.velocity.field_72449_c * (double)this.ticks);
            PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageFireBlastFX(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.preset.color, (float)this.preset.radius, 7), this.world.field_73011_w.getDimension());
            AxisAlignedBB box = new AxisAlignedBB(pos, pos);
            box = box.func_186662_g(this.preset.radius);
            for (Entity entity : this.world.func_175647_a(EntityLivingBase.class, box, e -> e != this.preset.getShooter() && pos.func_72436_e(e.func_174791_d()) < this.preset.radius * this.preset.radius)) {
                this.preset.effect.onEntityImpact(entity, (IProjectilePreset)this.preset);
            }
            if (!this.isAlive()) {
                this.preset.effect.onFizzle(this.world, pos, (IProjectilePreset)this.preset);
            }
        }

        public boolean isAlive() {
            return this.counter < this.preset.counter;
        }
    }
}

