/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mezz.jei.util.Translator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.ForgeRegistry;
import soot.Config;
import soot.Registry;
import soot.brewing.CaskManager;
import soot.brewing.EssenceStack;
import soot.brewing.EssenceType;
import soot.brewing.FluidModifier;
import soot.brewing.FluidPotionModifier;
import soot.brewing.deliverytypes.DeliveryBlast;
import soot.compat.jei.ExtraRecipeInfo;
import soot.recipe.CatalystInfo;
import soot.recipe.CatalystInfoSulfur;
import soot.recipe.ItemLiverStampingRecipe;
import soot.recipe.ItemRenameStampingRecipe;
import soot.recipe.RecipeAlchemicalMixer;
import soot.recipe.RecipeStill;
import soot.recipe.RecipeStillDoubleDistillation;
import soot.recipe.RecipeStillModifier;
import soot.recipe.RecipeStillModifierFood;
import soot.recipe.breweffects.EffectAdd;
import soot.recipe.breweffects.EffectInfo;
import soot.recipe.breweffects.EffectLoss;
import soot.recipe.breweffects.EffectMax;
import soot.recipe.breweffects.EffectMin;
import soot.recipe.breweffects.EffectMultiply;
import soot.tile.TileEntityStillBase;
import soot.util.FluidUtil;
import soot.util.MiscUtil;
import teamroots.embers.ConfigManager;
import teamroots.embers.Embers;
import teamroots.embers.RegistryManager;
import teamroots.embers.api.alchemy.AspectList;
import teamroots.embers.recipe.AlchemyRecipe;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.util.IngredientSpecial;

public class CraftingRegistry {
    public static HashSet<ResourceLocation> REMOVE_RECIPE_BY_RL = new HashSet();
    public static ArrayList<RecipeAlchemicalMixer> alchemicalMixingRecipes = new ArrayList();
    public static ArrayList<RecipeStill> stillRecipes = new ArrayList();
    public static ArrayList<CatalystInfo> stillCatalysts = new ArrayList();

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register(CraftingRegistry.class);
    }

    public static void removeRecipe(ResourceLocation resloc) {
        REMOVE_RECIPE_BY_RL.add(resloc);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void removeRecipes(RegistryEvent.Register<IRecipe> event) {
        ForgeRegistry reg = (ForgeRegistry)event.getRegistry();
        for (IRecipe recipe : reg) {
            REMOVE_RECIPE_BY_RL.stream().filter(loc -> loc.equals((Object)recipe.getRegistryName())).forEach(loc -> {
                IRecipe cfr_ignored_0 = (IRecipe)reg.remove(recipe.getRegistryName());
            });
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        OreIngredient ingotAntimony = new OreIngredient("ingotAntimony");
        OreIngredient ingotLead = new OreIngredient("ingotLead");
        OreIngredient ingotNickel = new OreIngredient("ingotNickel");
        Ingredient aspectDawnstone = Ingredient.func_193367_a((Item)RegistryManager.aspectus_dawnstone);
        OreIngredient blankGlass = new OreIngredient("blockGlassColorless");
        Ingredient fluidPipe = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(RegistryManager.pipe)});
        Ingredient accessor = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(RegistryManager.mech_accessor)});
        Ingredient distillationPipe = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)Registry.DISTILLATION_PIPE)});
        IngredientSpecial leadPickaxe = new IngredientSpecial(stack -> {
            Item item = stack.func_77973_b();
            return item instanceof ItemTool && item.getToolClasses(stack).contains("pickaxe") && ((ItemTool)item).func_77861_e().toLowerCase().contains("lead");
        });
        RecipeRegistry.alchemyRecipes.add(new AlchemyRecipe(new AspectList.AspectRangeList().setRange("dawnstone", 8, 16), (Ingredient)blankGlass, (List)Lists.newArrayList((Object[])new Ingredient[]{aspectDawnstone}), Registry.ESSENCE.getStack(EssenceType.NULL, 32)));
        RecipeRegistry.alchemyRecipes.add(new AlchemyRecipe(new AspectList.AspectRangeList().setRange("copper", 16, 32).setRange("lead", 32, 64), (Ingredient)blankGlass, (List)Lists.newArrayList((Object[])new Ingredient[]{ingotLead, Ingredient.func_193367_a((Item)RegistryManager.aspectus_lead), ingotLead, Ingredient.func_193367_a((Item)RegistryManager.archaic_circuit)}), new ItemStack((Block)Registry.ALCHEMY_GLOBE)));
        RecipeRegistry.alchemyRecipes.add(new AlchemyRecipe(new AspectList.AspectRangeList().setRange("silver", 24, 56).setRange("iron", 32, 64), distillationPipe, (List)Lists.newArrayList((Object[])new Ingredient[]{fluidPipe, blankGlass, fluidPipe, accessor}), new ItemStack((Block)Registry.DECANTER)));
        RecipeRegistry.alchemyRecipes.add(new AlchemyRecipe(new AspectList.AspectRangeList().setRange("iron", 64, 96).setRange("lead", 64, 96), (Ingredient)leadPickaxe, (List)Lists.newArrayList((Object[])new Ingredient[]{ingotAntimony, Ingredient.func_193367_a((Item)Registry.SULFUR_CLUMP), ingotAntimony, Ingredient.func_193367_a((Item)Registry.SIGNET_ANTIMONY)}), new ItemStack((Item)Registry.EITR)));
        RecipeRegistry.alchemyRecipes.add(new AlchemyRecipe(new AspectList.AspectRangeList().setRange("copper", 16, 32).setRange("iron", 32, 48).setRange("lead", 32, 48), Ingredient.func_193367_a((Item)RegistryManager.jet_augment), (List)Lists.newArrayList((Object[])new Ingredient[]{ingotNickel, Ingredient.func_193367_a((Item)Registry.SULFUR_CLUMP), ingotNickel, ingotNickel}), new ItemStack(Registry.WITCH_FIRE)));
        CraftingRegistry.removeRecipe(new ResourceLocation("embers", "archaic_bricks_2"));
        CraftingRegistry.removeRecipe(new ResourceLocation("embers", "plate_caminite_raw"));
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(Registry.STAMP_NUGGET_RAW), new ItemStack(Registry.STAMP_NUGGET), 0.1f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(Registry.STAMP_TEXT_RAW), new ItemStack(Registry.STAMP_TEXT), 0.1f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(Registry.CAMINITE_CLAY), new ItemStack(Registry.CAMINITE_LARGE_TILE), 0.1f);
        int nuggetSize = 16;
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"iron", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(Items.field_191525_da)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"gold", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(Items.field_151074_bl)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"copper", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_copper)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"dawnstone", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_dawnstone)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"lead", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_lead)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"silver", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_silver)));
        if (ConfigManager.enableTin) {
            RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"tin", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_tin)));
        }
        if (ConfigManager.enableAluminum) {
            RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"aluminum", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_aluminum)));
        }
        if (ConfigManager.enableBronze) {
            RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"bronze", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_bronze)));
        }
        if (ConfigManager.enableNickel) {
            RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"nickel", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_nickel)));
        }
        if (ConfigManager.enableElectrum) {
            RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"electrum", (int)nuggetSize), Ingredient.func_193367_a((Item)Registry.STAMP_NUGGET), new ItemStack(RegistryManager.nugget_electrum)));
        }
        RecipeRegistry.stampingRecipes.add(new ItemLiverStampingRecipe());
        if (Config.RENAME_STAMP) {
            RecipeRegistry.stampingRecipes.add(new ItemRenameStampingRecipe());
        }
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe(Ingredient.func_193367_a((Item)Items.field_151102_aT), FluidRegistry.getFluidStack((String)"sugar", (int)16)));
        ArrayList<Fluid> leveledMetals = new ArrayList<Fluid>();
        leveledMetals.add(FluidRegistry.getFluid((String)"lead"));
        if (ConfigManager.enableTin) {
            leveledMetals.add(FluidRegistry.getFluid((String)"tin"));
        }
        leveledMetals.add(FluidRegistry.getFluid((String)"iron"));
        leveledMetals.add(FluidRegistry.getFluid((String)"copper"));
        leveledMetals.add(FluidRegistry.getFluid((String)"silver"));
        leveledMetals.add(FluidRegistry.getFluid((String)"gold"));
        for (int i = 0; i < leveledMetals.size() - 1; ++i) {
            int e = i + 1;
            FluidStack currentLevel = new FluidStack((Fluid)leveledMetals.get(i), 4);
            FluidStack nextLevel = new FluidStack((Fluid)leveledMetals.get(e), 4);
            CraftingRegistry.addAlchemicalMixingRecipe(nextLevel, new FluidStack[]{currentLevel, FluidRegistry.getFluidStack((String)"alchemical_redstone", (int)3)}, new AspectList.AspectRangeList(AspectList.createStandard((int)0, (int)0, (int)0, (int)0, (int)(e * e * 4)), AspectList.createStandard((int)0, (int)0, (int)0, (int)0, (int)(e * e * 8))));
        }
        CraftingRegistry.addAlchemicalMixingRecipe(FluidRegistry.getFluidStack((String)"antimony", (int)12), new FluidStack[]{FluidRegistry.getFluidStack((String)"lead", (int)8), FluidRegistry.getFluidStack((String)"sugar", (int)4)}, new AspectList.AspectRangeList(AspectList.createStandard((int)0, (int)16, (int)0, (int)16, (int)0), AspectList.createStandard((int)0, (int)32, (int)0, (int)24, (int)0)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.func_193367_a((Item)RegistryManager.shard_ember), FluidRegistry.getFluidStack((String)"antimony", (int)144), Ingredient.func_193367_a((Item)RegistryManager.stamp_bar), new ItemStack(Registry.SIGNET_ANTIMONY)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, FluidRegistry.getFluidStack((String)"antimony", (int)144), Ingredient.func_193367_a((Item)RegistryManager.stamp_bar), new ItemStack(Registry.INGOT_ANTIMONY)));
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe((Ingredient)new OreIngredient("ingotAntimony"), FluidRegistry.getFluidStack((String)"antimony", (int)144)));
        OreDictionary.registerOre((String)"ingotAntimony", (ItemStack)new ItemStack(Registry.INGOT_ANTIMONY));
        OreDictionary.registerOre((String)"dustSulfur", (ItemStack)new ItemStack(Registry.SULFUR));
        OreDictionary.registerOre((String)"dustSugar", (ItemStack)new ItemStack(Items.field_151102_aT));
        CraftingRegistry.initAlcoholRecipes();
    }

    private static void initAlcoholRecipes() {
        FluidUtil.registerModifier(new FluidPotionModifier("ale", 0.0f, FluidModifier.EnumType.PRIMARY, FluidModifier.EffectType.POSITIVE, Registry.POTION_ALE, 4){

            @Override
            public EssenceStack toEssence(float amount) {
                if (amount > 0.0f) {
                    return new EssenceStack(EssenceType.GLASS, (int)Math.ceil(amount / 400.0f));
                }
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidPotionModifier("stoutness", 0.0f, FluidModifier.EnumType.PRIMARY, FluidModifier.EffectType.POSITIVE, Registry.POTION_STOUTNESS, 4){

            @Override
            public EssenceStack toEssence(float amount) {
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidPotionModifier("inner_fire", 0.0f, FluidModifier.EnumType.PRIMARY, FluidModifier.EffectType.POSITIVE, Registry.POTION_INNER_FIRE, 2){

            @Override
            public EssenceStack toEssence(float amount) {
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidPotionModifier("inspiration", 0.0f, FluidModifier.EnumType.PRIMARY, FluidModifier.EffectType.POSITIVE, Registry.POTION_INSPIRATION, 3){

            @Override
            public EssenceStack toEssence(float amount) {
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidPotionModifier("fire_lung", 0.0f, FluidModifier.EnumType.PRIMARY, FluidModifier.EffectType.POSITIVE, Registry.POTION_FIRE_LUNG, 2){

            @Override
            public EssenceStack toEssence(float amount) {
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidPotionModifier("snowpoff", 0.0f, FluidModifier.EnumType.PRIMARY, FluidModifier.EffectType.POSITIVE, Registry.POTION_SNOWPOFF, 3){

            @Override
            public EssenceStack toEssence(float amount) {
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidPotionModifier("lifedrinker", 0.0f, FluidModifier.EnumType.SECONDARY, FluidModifier.EffectType.POSITIVE, Registry.POTION_LIFEDRINKER, 0){

            @Override
            public EssenceStack toEssence(float amount) {
                if (amount > 0.0f) {
                    return new EssenceStack(EssenceType.LIFEDRINKER, (int)Math.ceil(amount / 400.0f));
                }
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidPotionModifier("steadfast", 0.0f, FluidModifier.EnumType.SECONDARY, FluidModifier.EffectType.POSITIVE, Registry.POTION_STEADFAST, 0){

            @Override
            public EssenceStack toEssence(float amount) {
                if (amount > 0.0f) {
                    return new EssenceStack(EssenceType.SPEED, (int)Math.ceil(amount / 400.0f));
                }
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidPotionModifier("experience_boost", 0.0f, FluidModifier.EnumType.SECONDARY, FluidModifier.EffectType.POSITIVE, Registry.POTION_EXPERIENCE_BOOST, 0){

            @Override
            public EssenceStack toEssence(float amount) {
                if (amount > 0.0f) {
                    return new EssenceStack(EssenceType.EXPERIENCE, (int)Math.ceil(amount / 400.0f));
                }
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidPotionModifier("glass", 0.0f, FluidModifier.EnumType.SECONDARY, FluidModifier.EffectType.NEGATIVE, Registry.POTION_GLASS, 9){

            @Override
            public EssenceStack toEssence(float amount) {
                if (amount > 0.0f) {
                    return new EssenceStack(EssenceType.GLASS, (int)Math.ceil(amount / 400.0f));
                }
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidPotionModifier("resistance", 0.0f, FluidModifier.EnumType.SECONDARY, FluidModifier.EffectType.POSITIVE, MobEffects.field_76429_m, 2){

            @Override
            public EssenceStack toEssence(float amount) {
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidPotionModifier("speed", 0.0f, FluidModifier.EnumType.SECONDARY, FluidModifier.EffectType.POSITIVE, MobEffects.field_76424_c, 3){

            @Override
            public EssenceStack toEssence(float amount) {
                if (amount > 0.0f) {
                    return new EssenceStack(EssenceType.SPEED, (int)Math.ceil(amount / 400.0f));
                }
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidPotionModifier("slow", 0.0f, FluidModifier.EnumType.SECONDARY, FluidModifier.EffectType.NEGATIVE, MobEffects.field_76421_d, 3){

            @Override
            public EssenceStack toEssence(float amount) {
                if (amount > 0.0f) {
                    return new EssenceStack(EssenceType.SLOWNESS, (int)Math.ceil(amount / 400.0f));
                }
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidPotionModifier("regeneration", 0.0f, FluidModifier.EnumType.SECONDARY, FluidModifier.EffectType.POSITIVE, MobEffects.field_76428_l, 3){

            @Override
            public EssenceStack toEssence(float amount) {
                if (amount > 0.0f) {
                    return new EssenceStack(EssenceType.REGENERATION, (int)Math.ceil(amount / 400.0f));
                }
                return super.toEssence(amount);
            }
        }.setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidModifier("viscosity", 1000.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.NEGATIVE){

            @Override
            public String getFormattedText(NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                if (value > 1000.0f) {
                    return I18n.func_135052_a((String)"distilling.modifier.dial.slower_chugging", (Object[])new Object[]{Float.valueOf(value)});
                }
                return I18n.func_135052_a((String)"distilling.modifier.dial.faster_chugging", (Object[])new Object[]{Float.valueOf(value)});
            }

            @Override
            public EssenceStack toEssence(float amount) {
                if (amount > 1000.0f) {
                    return new EssenceStack(EssenceType.SLOWNESS, (int)Math.ceil((amount - 1000.0f) / 200.0f));
                }
                return super.toEssence(amount);
            }
        });
        FluidUtil.registerModifier(new FluidModifier("light", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.NEUTRAL).setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidModifier("health", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE){

            @Override
            public void applyEffect(EntityLivingBase target, NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                if (value > 0.0f) {
                    target.func_70691_i(value);
                } else if (value < 0.0f) {
                    MiscUtil.damageWithoutInvulnerability((Entity)target, new DamageSource("acid"), value);
                }
            }

            @Override
            public String getFormattedText(NBTTagCompound compound, Fluid fluid) {
                int value = (int)Math.ceil(this.getOrDefault(compound, fluid) / 2.0f);
                DecimalFormat format = Embers.proxy.getDecimalFormat("embers.decimal_format.distilling.health");
                return I18n.func_135052_a((String)"distilling.modifier.dial.health", (Object[])new Object[]{this.getLocalizedName(), format.format(value)});
            }

            @Override
            public EssenceStack toEssence(float amount) {
                if (amount > 0.0f) {
                    return new EssenceStack(EssenceType.REGENERATION, (int)Math.ceil(amount / 2.0f));
                }
                if (amount < 0.0f) {
                    return new EssenceStack(EssenceType.DEATH, (int)Math.ceil(amount / 10.0f));
                }
                return super.toEssence(amount);
            }
        });
        FluidUtil.registerModifier(new FluidModifier("hunger", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE){

            @Override
            public void applyEffect(EntityLivingBase target, NBTTagCompound compound, Fluid fluid) {
                if (target instanceof EntityPlayer) {
                    int hunger = (int)compound.func_74760_g("hunger");
                    float saturation = compound.func_74760_g("saturation");
                    ((EntityPlayer)target).func_71024_bL().func_75122_a(hunger, saturation);
                }
            }

            @Override
            public String getFormattedText(NBTTagCompound compound, Fluid fluid) {
                int value = (int)Math.ceil(this.getOrDefault(compound, fluid) / 2.0f);
                DecimalFormat format = Embers.proxy.getDecimalFormat("embers.decimal_format.distilling.hunger");
                return I18n.func_135052_a((String)"distilling.modifier.dial.hunger", (Object[])new Object[]{this.getLocalizedName(), format.format(value)});
            }
        });
        FluidUtil.registerModifier(new FluidModifier("saturation", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE).setFormatType(null));
        FluidUtil.registerModifier(new FluidModifier("toxicity", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.NEGATIVE){

            @Override
            public void applyEffect(EntityLivingBase target, NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                if (value > 0.0f) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76431_k, (int)value * 4));
                }
                if (value >= 50.0f) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, (int)value * 2));
                }
                if (value >= 100.0f) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, (int)value - 50));
                }
                if (value >= 200.0f) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, (int)(value - 150.0f)));
                }
            }

            @Override
            public EssenceStack toEssence(float amount) {
                if (amount > 200.0f) {
                    return new EssenceStack(EssenceType.WITHER, (int)Math.ceil((amount - 200.0f) / 20.0f));
                }
                if (amount > 0.0f) {
                    return new EssenceStack(EssenceType.POISON, (int)Math.ceil(amount / 20.0f));
                }
                return EssenceStack.EMPTY;
            }
        });
        FluidUtil.registerModifier(new FluidModifier("sweetness", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE){

            @Override
            public void applyEffect(EntityLivingBase target, NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                if (value >= 50.0f) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76428_l, (int)value * 5));
                }
            }

            @Override
            public EssenceStack toEssence(float amount) {
                if (amount >= 50.0f) {
                    return new EssenceStack(EssenceType.REGENERATION, (int)Math.ceil((amount - 50.0f) / 10.0f));
                }
                if (amount > 0.0f) {
                    return new EssenceStack(EssenceType.SWEET, (int)Math.ceil(amount / 20.0f));
                }
                return EssenceStack.EMPTY;
            }
        });
        FluidUtil.registerModifier(new FluidModifier("heat", 300.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.NEUTRAL){

            @Override
            public void applyEffect(EntityLivingBase target, NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                if (value > 400.0f) {
                    MiscUtil.damageWithoutInvulnerability((Entity)target, new DamageSource("scalding"), 2.0f);
                    target.func_184185_a(SoundEvents.field_193806_fH, 1.0f, 1.0f);
                    if (target instanceof EntityPlayer) {
                        ((EntityPlayer)target).func_146105_b((ITextComponent)new TextComponentTranslation("message.scalding", new Object[0]), true);
                    }
                }
                if (value > 500.0f) {
                    target.func_70015_d((int)((value - 500.0f) / 10.0f));
                }
            }

            @Override
            public EssenceStack toEssence(float amount) {
                if (amount > 500.0f) {
                    return new EssenceStack(EssenceType.FIRE, (int)Math.ceil((amount - 500.0f) / 20.0f));
                }
                if (amount < 250.0f) {
                    return new EssenceStack(EssenceType.ICE, (int)Math.ceil((250.0f - amount) / 20.0f));
                }
                return EssenceStack.EMPTY;
            }
        });
        FluidUtil.registerModifier(new FluidModifier("volume", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.NEGATIVE){

            @Override
            public void applyEffect(EntityLivingBase target, NBTTagCompound compound, Fluid fluid) {
                float value = this.getOrDefault(compound, fluid);
                if (target.func_70681_au().nextDouble() * 100.0 < (double)value) {
                    target.func_70690_d(new PotionEffect(Registry.POTION_TIPSY, (int)value * 20));
                }
            }
        }.setFormatType("percent"));
        FluidUtil.registerModifier(new FluidModifier("concentration", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE).setFormatType("percent"));
        FluidUtil.registerModifier(new FluidModifier("duration", 1.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE).setFormatType("multiplier"));
        FluidUtil.registerModifier(new FluidModifier("fuel", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.NEUTRAL){

            @Override
            public String getFormattedText(NBTTagCompound compound, Fluid fluid) {
                int burntime = (int)this.getOrDefault(compound, fluid);
                if (burntime > 0) {
                    return super.getFormattedText(compound, fluid);
                }
                return I18n.func_135052_a((String)"distilling.modifier.dial.fire_retardant", (Object[])new Object[]{burntime});
            }
        });
        FluidUtil.registerModifier(new FluidModifier("alchemy_blast", 0.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE).setFormatType("name_only"));
        FluidUtil.registerModifier(new FluidModifier("alchemy_blast_radius", 8.0f, FluidModifier.EnumType.TERTIARY, FluidModifier.EffectType.POSITIVE));
        CaskManager.register("alchemy_blast", (gauntlet, elixir, user, fluid) -> {
            float radius = FluidUtil.getModifier(fluid, "alchemy_blast_radius");
            return new DeliveryBlast(user, fluid, 8.0, radius);
        });
        Fluid boiling_wort = FluidRegistry.getFluid((String)"boiling_wort");
        Fluid boiling_potato_juice = FluidRegistry.getFluid((String)"boiling_potato_juice");
        Fluid boiling_beetroot_soup = FluidRegistry.getFluid((String)"boiling_beetroot_soup");
        FluidUtil.setDefaultValue(boiling_beetroot_soup, "hunger", 6.0f);
        FluidUtil.setDefaultValue(boiling_beetroot_soup, "saturation", 0.6f);
        Fluid boiling_verdigris = FluidRegistry.getFluid((String)"boiling_wormwood");
        FluidUtil.setDefaultValue(boiling_verdigris, "toxicity", 100.0f);
        Fluid ale = FluidRegistry.getFluid((String)"dwarven_ale");
        FluidUtil.setDefaultValue(ale, "ale", 1200.0f);
        FluidUtil.setDefaultValue(ale, "volume", 20.0f);
        FluidUtil.setDefaultValue(ale, "fuel", 400.0f);
        Fluid inner_fire = FluidRegistry.getFluid((String)"inner_fire");
        FluidUtil.setDefaultValue(inner_fire, "inner_fire", 1000.0f);
        FluidUtil.setDefaultValue(inner_fire, "heat", 600.0f);
        FluidUtil.setDefaultValue(inner_fire, "volume", 10.0f);
        FluidUtil.setDefaultValue(inner_fire, "fuel", 1600.0f);
        Fluid umber_ale = FluidRegistry.getFluid((String)"umber_ale");
        Fluid vodka = FluidRegistry.getFluid((String)"vodka");
        FluidUtil.setDefaultValue(vodka, "stoutness", 1600.0f);
        FluidUtil.setDefaultValue(vodka, "volume", 30.0f);
        FluidUtil.setDefaultValue(vodka, "fuel", 1200.0f);
        Fluid snowpoff = FluidRegistry.getFluid((String)"snowpoff");
        FluidUtil.setDefaultValue(snowpoff, "snowpoff", 1000.0f);
        FluidUtil.setDefaultValue(snowpoff, "heat", 200.0f);
        FluidUtil.setDefaultValue(snowpoff, "volume", 20.0f);
        FluidUtil.setDefaultValue(snowpoff, "fuel", -2000.0f);
        Fluid absinthe = FluidRegistry.getFluid((String)"absinthe");
        FluidUtil.setDefaultValue(absinthe, "inspiration", 400.0f);
        FluidUtil.setDefaultValue(absinthe, "toxicity", 50.0f);
        FluidUtil.setDefaultValue(absinthe, "volume", 50.0f);
        FluidUtil.setDefaultValue(absinthe, "fuel", 800.0f);
        Fluid methanol = FluidRegistry.getFluid((String)"methanol");
        FluidUtil.setDefaultValue(methanol, "fire_lung", 200.0f);
        FluidUtil.setDefaultValue(methanol, "toxicity", 10.0f);
        FluidUtil.setDefaultValue(methanol, "fuel", 2400.0f);
        ItemStack smallFern = new ItemStack((Block)Blocks.field_150329_H, 1, BlockTallGrass.EnumType.FERN.func_177044_a());
        ItemStack bigFern = new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.FERN.func_176936_a());
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe((Ingredient)new OreIngredient("cropWheat"), new FluidStack(boiling_wort, 100)));
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe((Ingredient)new OreIngredient("cropPotato"), new FluidStack(boiling_potato_juice, 50)));
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe(Ingredient.func_193367_a((Item)Items.field_185164_cV), new FluidStack(boiling_beetroot_soup, 50)));
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{smallFern}), new FluidStack(boiling_verdigris, 50)));
        RecipeRegistry.meltingRecipes.add(new ItemMeltingRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{bigFern}), new FluidStack(boiling_verdigris, 100)));
        RecipeRegistry.mixingRecipes.add(new FluidMixingRecipe(new FluidStack[]{new FluidStack(ale, 4), FluidRegistry.getFluidStack((String)"lava", (int)1)}, new FluidStack(inner_fire, 4)));
        stillRecipes.add(new RecipeStill(CraftingRegistry.getRL("brew_ale"), new FluidStack(boiling_wort, 1), Ingredient.field_193370_a, 0, new FluidStack(ale, 1)).setEssence(Lists.newArrayList((Object[])new EssenceStack[]{new EssenceStack(EssenceType.GLASS, 1)})));
        stillRecipes.add(new RecipeStill(CraftingRegistry.getRL("brew_vodka"), new FluidStack(boiling_potato_juice, 3), Ingredient.field_193370_a, 0, new FluidStack(vodka, 2)).setEssence(Lists.newArrayList((Object[])new EssenceStack[]{new EssenceStack(EssenceType.VILE, 1)})));
        stillRecipes.add(new RecipeStill(CraftingRegistry.getRL("brew_snowpoff"), new FluidStack(vodka, 1), Ingredient.func_193367_a((Item)Items.field_151126_ay), 1, new FluidStack(snowpoff, 1)).setEssence(Lists.newArrayList((Object[])new EssenceStack[]{new EssenceStack(EssenceType.ICE, 5)})));
        stillRecipes.add(new RecipeStill(CraftingRegistry.getRL("brew_absinthe"), new FluidStack(boiling_verdigris, 1), Ingredient.func_193367_a((Item)Items.field_151102_aT), 0, new FluidStack(absinthe, 1)).setEssence(Lists.newArrayList((Object[])new EssenceStack[]{new EssenceStack(EssenceType.POISON, 5), new EssenceStack(EssenceType.EXPERIENCE, 1)})));
        stillRecipes.add(new RecipeStill(CraftingRegistry.getRL("brew_methanol"), null, (Ingredient)new OreIngredient("logWood"), 1, new FluidStack(methanol, 1)).setEssence(Lists.newArrayList((Object[])new EssenceStack[]{new EssenceStack(EssenceType.FIRE, 3), new EssenceStack(EssenceType.POISON, 1)})));
        stillRecipes.add(new RecipeStill(CraftingRegistry.getRL("extract_lava"), new FluidStack(FluidRegistry.LAVA, 3), Ingredient.field_193370_a, 1, new FluidStack(FluidRegistry.LAVA, 1)).setEssence(Lists.newArrayList((Object[])new EssenceStack[]{new EssenceStack(EssenceType.FIRE, 10)})));
        stillRecipes.add(new RecipeStill(CraftingRegistry.getRL("extract_iron"), new FluidStack(RegistryManager.fluid_molten_iron, 3), Ingredient.field_193370_a, 1, new FluidStack(RegistryManager.fluid_molten_iron, 2)).setEssence(Lists.newArrayList((Object[])new EssenceStack[]{new EssenceStack(EssenceType.EXTRACT, 15)})));
        ArrayList<Fluid> allSoups = new ArrayList<Fluid>();
        allSoups.add(boiling_beetroot_soup);
        ArrayList<Fluid> allAlcohols = new ArrayList<Fluid>();
        allAlcohols.add(ale);
        allAlcohols.add(vodka);
        allAlcohols.add(inner_fire);
        allAlcohols.add(umber_ale);
        allAlcohols.add(methanol);
        allAlcohols.add(absinthe);
        allAlcohols.add(snowpoff);
        ArrayList<Fluid> allDrinks = new ArrayList<Fluid>(allAlcohols);
        allDrinks.addAll(allSoups);
        allDrinks.add(boiling_verdigris);
        stillCatalysts.add(new CatalystInfo(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{smallFern}), 250));
        stillCatalysts.add(new CatalystInfo(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{bigFern}), 500));
        stillCatalysts.add(new CatalystInfo((Ingredient)new OreIngredient("dustSugar"), 100));
        stillCatalysts.add(new CatalystInfo(Ingredient.func_193367_a((Item)Items.field_151126_ay), 250));
        stillCatalysts.add(new CatalystInfo((Ingredient)new OreIngredient("logWood"), 750));
        stillCatalysts.add(new CatalystInfo(Ingredient.func_193367_a((Item)Registry.ESSENCE), 1000));
        stillCatalysts.add(new CatalystInfo((Ingredient)new OreIngredient("dustSulfur"), 100));
        stillCatalysts.add(new CatalystInfoSulfur());
        stillRecipes.add(new RecipeStillDoubleDistillation(CraftingRegistry.getRL("modify_double_distill"), allAlcohols, Ingredient.field_193370_a, 0){

            @Override
            public int getInputConsumed() {
                return 3;
            }
        }.addEffect(new EffectAdd("concentration", 10.0f, 120.0f, false)).addEffect(new EffectMultiply("concentration", 1.8f, 0.0f, 120.0f, false)).addEffect(new EffectMultiply("volume", 1.1f, false)).addEffect(new EffectLoss(3, 2)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("modify_lifedrinker"), allAlcohols, Ingredient.func_193367_a((Item)Items.field_151073_bk), 1).addEffect(new EffectInfo("lifedrinker")).addEffect(new EffectAdd("lifedrinker", 600.0f, 18000.0f, true)).addEffect(new EffectMultiply("lifedrinker", 1.6f, Float.NEGATIVE_INFINITY, 18000.0f, true)).addEffect(new EffectAdd("toxicity", 10.0f, false)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("modify_steadfast"), allAlcohols, Ingredient.func_193367_a((Item)Items.field_179556_br), 1).addEffect(new EffectInfo("steadfast")).addEffect(new EffectAdd("steadfast", 600.0f, 18000.0f, true)).addEffect(new EffectMultiply("steadfast", 1.6f, Float.NEGATIVE_INFINITY, 18000.0f, true)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("modify_experience_boost"), allDrinks, Ingredient.func_193367_a((Item)Items.field_151110_aK), 1).addEffect(new EffectInfo("experience_boost")).addEffect(new EffectAdd("experience_boost", 600.0f, 18000.0f, true)).addEffect(new EffectMultiply("experience_boost", 1.6f, Float.NEGATIVE_INFINITY, 18000.0f, true)).addEffect(new EffectAdd("toxicity", 10.0f, 50.0f, false)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("modify_duration_bonus"), allAlcohols, (Ingredient)new OreIngredient("dustRedstone"), 1).addEffect(new EffectAdd("duration", 0.5f, 2.5f, false)).addEffect(new EffectAdd("toxicity", 5.0f, false)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("modify_sweetness_bonus"), allDrinks, (Ingredient)new OreIngredient("dustSugar"), 1).addEffect(new EffectAdd("sweetness", 15.0f, 80.0f, false)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("modify_purify"), allDrinks, (Ingredient)new OreIngredient("dustPrismarine"), 1).addEffect(new EffectMultiply("toxicity", 0.8f, 0.0f, Float.POSITIVE_INFINITY, false)).addEffect(new EffectAdd("toxicity", -20.0f, 0.0f, false)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("modify_taint"), allDrinks, Ingredient.func_193367_a((Item)Items.field_151071_bq), 1){

            @Override
            public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
                NBTTagCompound compound = FluidUtil.createModifiers(output);
                for (String modifier : FluidUtil.SORTED_MODIFIER_KEYS) {
                    FluidModifier.EffectType effectType = FluidUtil.getEffectType(modifier);
                    if (effectType == FluidModifier.EffectType.NEUTRAL) continue;
                    float defaultValue = FluidUtil.getDefault(modifier);
                    float value = this.getModifierOrDefault(modifier, compound, output);
                    if (!(value > defaultValue && effectType == FluidModifier.EffectType.POSITIVE) && (!(value < defaultValue) || effectType != FluidModifier.EffectType.NEGATIVE)) continue;
                    compound.func_74776_a(modifier, defaultValue);
                }
            }

            @Override
            public void modifyTooltip(List<String> tooltip) {
                super.modifyTooltip(tooltip);
                this.addModifier(tooltip, "erase_positive", false);
            }
        });
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("modify_heal"), allDrinks, (Ingredient)new OreIngredient("cropNetherWart"), 1).addEffect(new EffectAdd("health", 4.0f, false)).addEffect(new EffectAdd("hunger", -3.0f, false)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("modify_cool"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150432_aD)}), 1).addEffect(new EffectMultiply("heat", 0.5f, 200.0f, Float.POSITIVE_INFINITY, false)));
        stillRecipes.add(new RecipeStillModifierFood(CraftingRegistry.getRL("soup_potato"), allSoups, (Ingredient)new OreIngredient("cropPotato"), 1, 2, 0.3f));
        stillRecipes.add(new RecipeStillModifierFood(CraftingRegistry.getRL("soup_carrot"), allSoups, (Ingredient)new OreIngredient("cropCarrot"), 1, 1, 0.2f));
        stillRecipes.add(new RecipeStillModifierFood(CraftingRegistry.getRL("soup_wheat"), allSoups, (Ingredient)new OreIngredient("cropWheat"), 1, 4, 0.6f).addEffect(new EffectInfo("thick_soup", TextFormatting.BLUE)).addEffect(new EffectAdd("viscosity", 1000.0f, true)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_sweet"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.SWEET)}), 1).addEffect(new EffectAdd("sweetness", 20.0f, false)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_poison"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.POISON)}), 1).addEffect(new EffectAdd("toxicity", 20.0f, false)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_wither"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.WITHER)}), 1).addEffect(new EffectInfo("wither", TextFormatting.RED)).addEffect(new EffectMax("toxicity", 200.0f, false)).addEffect(new EffectAdd("toxicity", 50.0f, false)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_death"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.DEATH)}), 1).addEffect(new EffectInfo("death", TextFormatting.RED)).addEffect(new EffectAdd("health", -10.0f, false)).addEffect(new EffectMin("health", -20.0f, true)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_vile"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.VILE)}), 1){

            @Override
            public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
                NBTTagCompound compound = FluidUtil.createModifiers(output);
                float health = this.getModifierOrDefault("health", compound, output);
                float toxicity = this.getModifierOrDefault("toxicity", compound, output);
                float toConvert = Math.max(0.0f, Math.min(toxicity, 20.0f));
                compound.func_74776_a("health", health - toConvert / 2.0f);
                compound.func_74776_a("toxicity", toxicity - toConvert);
            }

            @Override
            public void modifyTooltip(List<String> tooltip) {
                super.modifyTooltip(tooltip);
                this.addModifier(tooltip, "vile", false);
            }
        });
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_fire"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.FIRE)}), 1).addEffect(new EffectAdd("heat", 40.0f, false)).addEffect(new EffectAdd("fuel", 500.0f, false)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_ice"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.ICE)}), 1).addEffect(new EffectAdd("heat", -20.0f, 0.0f, false)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_lifedrinker"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.LIFEDRINKER)}), 1).addEffect(new EffectInfo("lifedrinker")).addEffect(new EffectAdd("lifedrinker", 800.0f, true)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_glass"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.GLASS)}), 1).addEffect(new EffectInfo("glass")).addEffect(new EffectAdd("glass", 800.0f, true)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_speed"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.SPEED)}), 1).addEffect(new EffectInfo("speed")).addEffect(new EffectAdd("speed", 800.0f, true)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_slowness"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.SLOWNESS)}), 1).addEffect(new EffectInfo("slow")).addEffect(new EffectAdd("slow", 800.0f, true)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_regeneration"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.REGENERATION)}), 1).addEffect(new EffectInfo("regeneration")).addEffect(new EffectAdd("regeneration", 800.0f, true)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_experience"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.EXPERIENCE)}), 1).addEffect(new EffectInfo("experience_boost")).addEffect(new EffectAdd("experience_boost", 800.0f, true)));
        stillRecipes.add(new RecipeStillModifier(CraftingRegistry.getRL("essence_extract"), allDrinks, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.EXTRACT)}), 1){

            @Override
            public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
                NBTTagCompound compound = FluidUtil.createModifiers(output);
                String minModifier = this.getSmallestModifier(output, compound);
                if (minModifier != null) {
                    compound.func_74776_a(minModifier, FluidUtil.getDefault(minModifier));
                }
            }

            @Override
            public List<EssenceStack> getEssenceOutput(TileEntityStillBase tile, FluidStack input, ItemStack catalyst) {
                NBTTagCompound compound = FluidUtil.createModifiers(input);
                String minModifier = this.getSmallestModifier(input, compound);
                if (minModifier != null) {
                    float value = this.getModifierOrDefault(minModifier, compound, input);
                    return Lists.newArrayList((Object[])new EssenceStack[]{FluidUtil.modifierToEssence(minModifier, value)});
                }
                return Lists.newArrayList();
            }

            @Override
            public List<ExtraRecipeInfo> getExtraInfo() {
                return Lists.newArrayList((Object[])new ExtraRecipeInfo[]{new ExtraRecipeInfo(Lists.newArrayList((Object[])new ItemStack[]{Registry.ESSENCE.getStack(EssenceType.CHAOS)})){

                    @Override
                    public void modifyTooltip(List<String> strings) {
                        strings.clear();
                        strings.add(Translator.translateToLocalFormatted((String)"distilling.effect.decanter", (Object[])new Object[0]));
                        strings.add(Translator.translateToLocalFormatted((String)"distilling.effect.decanter.desc", (Object[])new Object[0]));
                        strings.add(Translator.translateToLocalFormatted((String)"distilling.effect.decanter.extract", (Object[])new Object[0]));
                    }
                }});
            }

            @Override
            public void modifyTooltip(List<String> tooltip) {
                super.modifyTooltip(tooltip);
                this.addModifier(tooltip, "extract", true);
            }

            private String getSmallestModifier(FluidStack output, NBTTagCompound compound) {
                float minValue = Float.POSITIVE_INFINITY;
                String minModifier = null;
                for (String modifier : FluidUtil.SORTED_MODIFIER_KEYS) {
                    float value;
                    EssenceStack essence;
                    if (FluidUtil.getType(modifier) == FluidModifier.EnumType.PRIMARY || (essence = FluidUtil.modifierToEssence(modifier, value = this.getModifierOrDefault(modifier, compound, output) - FluidUtil.getDefault(modifier))).isEmpty() || value == 0.0f || !(Math.abs(value) < minValue)) continue;
                    minModifier = modifier;
                    minValue = Math.abs(value);
                }
                return minModifier;
            }
        });
    }

    public static void addAlchemicalMixingRecipe(FluidStack output, FluidStack[] input, AspectList.AspectRangeList aspects) {
        aspects.fixMathematicalError();
        aspects.setSeedOffset(alchemicalMixingRecipes.size());
        alchemicalMixingRecipes.add(new RecipeAlchemicalMixer(input, output, aspects));
    }

    public static RecipeAlchemicalMixer getAlchemicalMixingRecipe(ArrayList<FluidStack> fluids) {
        RecipeAlchemicalMixer matchedRecipe = null;
        for (RecipeAlchemicalMixer recipe : alchemicalMixingRecipes) {
            if (!recipe.matches(fluids) || matchedRecipe != null && recipe.inputs.size() <= matchedRecipe.inputs.size()) continue;
            matchedRecipe = recipe;
        }
        return matchedRecipe;
    }

    public static RecipeStill getStillRecipe(TileEntityStillBase tile, FluidStack stack, ItemStack catalyst) {
        RecipeStill matchedRecipe = null;
        for (RecipeStill recipe : stillRecipes) {
            if (!recipe.matches(tile, stack, catalyst) || matchedRecipe != null && matchedRecipe.input != null && !matchedRecipe.catalystInput.apply(ItemStack.field_190927_a)) continue;
            matchedRecipe = recipe;
        }
        return matchedRecipe;
    }

    public static int getStillCatalyst(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        CatalystInfo matchedCatalyst = stillCatalysts.stream().filter(catalyst -> catalyst.matches(stack)).findFirst().orElse(null);
        return matchedCatalyst == null ? 1000 : matchedCatalyst.getAmount(stack);
    }

    private static ResourceLocation getRL(String name) {
        return new ResourceLocation("soot", name);
    }
}

