/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.util.Translator;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import soot.Registry;
import soot.brewing.EssenceStack;
import soot.brewing.EssenceType;
import soot.compat.jei.ExtraRecipeInfo;
import soot.tile.TileEntityStillBase;

public class RecipeStill {
    public ResourceLocation id;
    public FluidStack input;
    public Ingredient catalystInput;
    public int catalystConsumed;
    public FluidStack output;
    public List<EssenceStack> essence = new ArrayList<EssenceStack>();
    boolean exactMatch = false;

    public RecipeStill(ResourceLocation id, FluidStack input, Ingredient catalystInput, int catalystConsumed, FluidStack output) {
        this.id = id;
        this.input = input;
        this.catalystInput = catalystInput;
        this.output = output;
        this.catalystConsumed = catalystConsumed;
    }

    public RecipeStill setEssence(List<EssenceStack> essence) {
        this.essence = essence;
        return this;
    }

    public RecipeStill setExact() {
        this.exactMatch = true;
        return this;
    }

    public List<EssenceStack> getEssences() {
        return this.essence;
    }

    public List<EssenceStack> getEssenceOutput(TileEntityStillBase tile, FluidStack input, ItemStack catalyst) {
        return this.essence;
    }

    public List<FluidStack> getInputs() {
        return Lists.newArrayList((Object[])new FluidStack[]{this.input});
    }

    public List<FluidStack> getOutputs() {
        return Lists.newArrayList((Object[])new FluidStack[]{this.output});
    }

    public List<ItemStack> getEssenceItems() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (EssenceStack stack : this.essence) {
            stacks.add(Registry.ESSENCE.getStack(stack.getEssence()));
        }
        return stacks;
    }

    public ArrayList<ItemStack> getCatalysts() {
        return Lists.newArrayList((Object[])this.catalystInput.func_193365_a());
    }

    public void modifyTooltip(List<String> tooltip) {
    }

    public int getInputConsumed() {
        return this.input != null ? this.input.amount : 0;
    }

    public boolean matches(TileEntityStillBase tile, FluidStack stack, ItemStack catalyst) {
        return this.catalystInput.apply(catalyst) && (this.input == null || stack != null && (this.exactMatch ? this.input.isFluidEqual(stack) : this.input.getFluid() == stack.getFluid()) && stack.amount >= this.getInputConsumed());
    }

    public FluidStack getOutput(TileEntityStillBase tile, FluidStack input) {
        return this.output.copy();
    }

    public List<ExtraRecipeInfo> getExtraInfo() {
        ArrayList extraInfo = Lists.newArrayList();
        this.addEssenceInfo(extraInfo);
        return extraInfo;
    }

    private void addEssenceInfo(ArrayList<ExtraRecipeInfo> extraInfo) {
        for (EssenceStack stack : this.getEssences()) {
            final EssenceType type = stack.getEssence();
            final int amount = stack.getAmount();
            ItemStack essenceItem = Registry.ESSENCE.getStack(type);
            extraInfo.add(new ExtraRecipeInfo(Lists.newArrayList((Object[])new ItemStack[]{essenceItem})){

                @Override
                public void modifyTooltip(List<String> strings) {
                    String essenceName = Translator.translateToLocalFormatted((String)("distilling.essence." + type.getName() + ".name"), (Object[])new Object[0]);
                    strings.clear();
                    strings.add(Translator.translateToLocalFormatted((String)"distilling.effect.decanter", (Object[])new Object[0]));
                    strings.add(Translator.translateToLocalFormatted((String)"distilling.effect.decanter.desc", (Object[])new Object[0]));
                    strings.add(Translator.translateToLocalFormatted((String)"distilling.effect.decanter.essence", (Object[])new Object[]{essenceName, amount}));
                }
            });
        }
    }

    public String toString() {
        return this.id.toString();
    }
}

