/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import mezz.jei.util.Translator;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import soot.Registry;
import soot.compat.jei.ExtraRecipeInfo;
import soot.recipe.RecipeStillModifier;
import soot.tile.TileEntityStillBase;
import teamroots.embers.api.upgrades.UpgradeUtil;

public class RecipeStillDoubleDistillation
extends RecipeStillModifier {
    public static final String TAG_DOUBLE_DISTILL = "can_double_distill";

    public RecipeStillDoubleDistillation(ResourceLocation id, Collection<Fluid> validFluids, Ingredient catalystInput, int catalystConsumed) {
        super(id, validFluids, catalystInput, catalystConsumed);
    }

    @Override
    public boolean matches(TileEntityStillBase tile, FluidStack stack, ItemStack catalyst) {
        boolean canDoubleDistill = tile == null || UpgradeUtil.getOtherParameter((TileEntity)tile, (String)TAG_DOUBLE_DISTILL, (boolean)false, tile.upgrades);
        return canDoubleDistill && super.matches(tile, stack, catalyst);
    }

    @Override
    public List<ExtraRecipeInfo> getExtraInfo() {
        List<ExtraRecipeInfo> extraInfo = super.getExtraInfo();
        extraInfo.add(0, new ExtraRecipeInfo(Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)Registry.DISTILLATION_PIPE)})){

            @Override
            public void modifyTooltip(List<String> strings) {
                strings.clear();
                strings.add(Translator.translateToLocalFormatted((String)"distilling.effect.double_distillation", (Object[])new Object[0]));
                strings.add(Translator.translateToLocalFormatted((String)"distilling.effect.double_distillation.desc", (Object[])new Object[0]));
            }
        });
        return extraInfo;
    }
}

