/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.util.Translator;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import soot.recipe.RecipeStill;
import soot.recipe.breweffects.IBrewEffect;
import soot.tile.TileEntityStillBase;
import soot.util.FluidUtil;

public class RecipeStillModifier
extends RecipeStill {
    public HashSet<Fluid> validFluids = new HashSet();
    public List<IBrewEffect> effects = new ArrayList<IBrewEffect>();

    public RecipeStillModifier(ResourceLocation id, Collection<Fluid> validFluids, Ingredient catalystInput, int catalystConsumed) {
        super(id, null, catalystInput, catalystConsumed, null);
        this.validFluids = new HashSet<Fluid>(validFluids);
    }

    public RecipeStillModifier addEffect(IBrewEffect effect) {
        this.effects.add(effect);
        return this;
    }

    @Override
    public boolean matches(TileEntityStillBase tile, FluidStack stack, ItemStack catalyst) {
        return stack != null && this.catalystInput.apply(catalyst) && this.validFluids.contains(stack.getFluid()) && stack.amount >= this.getInputConsumed();
    }

    @Override
    public int getInputConsumed() {
        return 1;
    }

    @Override
    public List<FluidStack> getInputs() {
        return this.validFluids.stream().map(fluid -> new FluidStack(fluid, this.getInputConsumed())).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public List<FluidStack> getOutputs() {
        return this.getInputs();
    }

    @Override
    public FluidStack getOutput(TileEntityStillBase tile, FluidStack input) {
        FluidStack outputStack = input.copy();
        outputStack.amount = 1;
        this.modifyOutput(tile, outputStack);
        return outputStack;
    }

    public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
        NBTTagCompound compound = FluidUtil.createModifiers(output);
        for (IBrewEffect effect : this.effects) {
            effect.modify(output, compound);
        }
    }

    @Override
    public void modifyTooltip(List<String> tooltip) {
        super.modifyTooltip(tooltip);
        tooltip.remove(1);
        tooltip.add(1, TextFormatting.LIGHT_PURPLE + Translator.translateToLocalFormatted((String)"distilling.effect.header", (Object[])new Object[0]));
        for (IBrewEffect effect : this.effects) {
            effect.modifyTooltip(tooltip);
        }
    }

    protected void addModifier(List<String> tooltip, String modifier, boolean positive) {
        TextFormatting color = positive ? TextFormatting.GREEN : TextFormatting.RED;
        tooltip.add(tooltip.size() - 1, color + Translator.translateToLocalFormatted((String)("distilling.effect." + modifier), (Object[])new Object[0]));
    }

    protected void addModifierLinear(List<String> tooltip, String modifier, float amount, boolean positive) {
        TextFormatting color;
        String key;
        DecimalFormat format = new DecimalFormat("#.####");
        if (amount > 0.0f) {
            key = "distilling.effect.add";
            color = positive ? TextFormatting.GREEN : TextFormatting.RED;
        } else {
            key = "distilling.effect.sub";
            color = positive ? TextFormatting.RED : TextFormatting.GREEN;
        }
        tooltip.add(tooltip.size() - 1, color + Translator.translateToLocalFormatted((String)key, (Object[])new Object[]{Translator.translateToLocal((String)("distilling.modifier." + modifier + ".name")), format.format(Math.abs(amount))}));
    }

    protected void addModifierPercent(List<String> tooltip, String modifier, float amount, boolean positive) {
        TextFormatting color;
        String key;
        DecimalFormat format = new DecimalFormat("#.####");
        if (amount > 0.0f) {
            key = "distilling.effect.add_percent";
            color = positive ? TextFormatting.GREEN : TextFormatting.RED;
        } else {
            key = "distilling.effect.sub_percent";
            color = positive ? TextFormatting.RED : TextFormatting.GREEN;
        }
        tooltip.add(tooltip.size() - 1, color + Translator.translateToLocalFormatted((String)key, (Object[])new Object[]{Translator.translateToLocal((String)("distilling.modifier." + modifier + ".name")), format.format(Math.abs(amount))}));
    }

    protected void addModifierLoss(List<String> tooltip, float amount) {
        DecimalFormat format = new DecimalFormat("#.####");
        tooltip.add(tooltip.size() - 1, TextFormatting.RED + Translator.translateToLocalFormatted((String)"distilling.effect.loss", (Object[])new Object[]{format.format(amount)}));
    }

    public float getModifierOrDefault(String name, NBTTagCompound compound, FluidStack fluid) {
        return FluidUtil.getModifier(compound, fluid != null ? fluid.getFluid() : null, name);
    }
}

