/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe.breweffects;

import java.text.DecimalFormat;
import java.util.List;
import mezz.jei.util.Translator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import soot.brewing.FluidModifier;
import soot.recipe.breweffects.IBrewEffect;
import soot.util.FluidUtil;
import teamroots.embers.util.DecimalFormats;

public class EffectAdd
implements IBrewEffect {
    String modifier;
    float amount;
    float limit;
    boolean hidden;

    public EffectAdd(String modifier, float amount, boolean hidden) {
        this(modifier, amount, amount * Float.POSITIVE_INFINITY, hidden);
    }

    public EffectAdd(String modifier, float amount, float limit, boolean hidden) {
        this.modifier = modifier;
        this.amount = amount;
        this.limit = limit;
        this.hidden = hidden;
    }

    private FluidModifier.EffectType getEffectType() {
        return FluidUtil.getEffectType(this.modifier);
    }

    @Override
    public void modify(FluidStack output, NBTTagCompound compound) {
        float value = this.getModifierOrDefault(this.modifier, compound, output);
        compound.func_74776_a(this.modifier, this.add(value));
    }

    private float add(float base) {
        if (this.amount > 0.0f && base < this.limit) {
            return Math.min(base + this.amount, this.limit);
        }
        if (this.amount < 0.0f && base > this.limit) {
            return Math.max(base + this.amount, this.limit);
        }
        return base;
    }

    @Override
    public void modifyTooltip(List<String> tooltip) {
        TextFormatting color;
        String key;
        String formatType = FluidUtil.getFormatType(this.modifier);
        DecimalFormat format = DecimalFormats.getDecimalFormat((String)("embers.decimal_format.modifier." + formatType));
        if (formatType == null || this.hidden) {
            return;
        }
        FluidModifier.EffectType type = this.getEffectType();
        if (this.amount > 0.0f) {
            key = "distilling.effect.add";
            color = this.getTextColor(type, false);
        } else {
            key = "distilling.effect.sub";
            color = this.getTextColor(type, true);
        }
        tooltip.add(tooltip.size() - 1, color + Translator.translateToLocalFormatted((String)key, (Object[])new Object[]{Translator.translateToLocal((String)("distilling.modifier." + this.modifier + ".name")), format.format(Math.abs(this.amount))}));
    }
}

