/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe.breweffects;

import java.util.List;
import mezz.jei.util.Translator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import soot.recipe.breweffects.IBrewEffect;
import soot.util.FluidUtil;

public class EffectInfo
implements IBrewEffect {
    String modifier;
    String color;

    public EffectInfo(String modifier) {
        this(modifier, EffectInfo.getModifierColor(modifier).toString());
    }

    public EffectInfo(String modifier, TextFormatting color) {
        this(modifier, color.toString());
    }

    public EffectInfo(String modifier, String color) {
        this.modifier = modifier;
        this.color = color;
    }

    private static TextFormatting getModifierColor(String modifier) {
        switch (FluidUtil.getEffectType(modifier)) {
            case POSITIVE: {
                return TextFormatting.GREEN;
            }
            case NEGATIVE: {
                return TextFormatting.RED;
            }
            case NEUTRAL: {
                return TextFormatting.BLUE;
            }
        }
        return TextFormatting.GRAY;
    }

    @Override
    public void modify(FluidStack output, NBTTagCompound compound) {
    }

    @Override
    public void modifyTooltip(List<String> tooltip) {
        tooltip.add(tooltip.size() - 1, this.color + Translator.translateToLocalFormatted((String)("distilling.effect." + this.modifier), (Object[])new Object[0]));
    }
}

