/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe.breweffects;

import java.text.DecimalFormat;
import java.util.List;
import mezz.jei.util.Translator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import soot.recipe.breweffects.IBrewEffect;

public class EffectLoss
implements IBrewEffect {
    int ratioInput;
    int ratioOutput;

    public EffectLoss(int ratioInput, int ratioOutput) {
        this.ratioInput = ratioInput;
        this.ratioOutput = ratioOutput;
    }

    @Override
    public void modify(FluidStack output, NBTTagCompound compound) {
        output.amount = this.ratioOutput;
    }

    @Override
    public void modifyTooltip(List<String> tooltip) {
        DecimalFormat format = new DecimalFormat("#%");
        if (this.ratioOutput > this.ratioInput) {
            tooltip.add(tooltip.size() - 1, TextFormatting.GREEN + Translator.translateToLocalFormatted((String)"distilling.effect.gain", (Object[])new Object[]{format.format((float)this.ratioOutput * 1.0f / (float)this.ratioInput - 1.0f)}));
        } else {
            tooltip.add(tooltip.size() - 1, TextFormatting.RED + Translator.translateToLocalFormatted((String)"distilling.effect.loss", (Object[])new Object[]{format.format((float)this.ratioOutput * 1.0f / (float)this.ratioInput - 1.0f)}));
        }
    }
}

