/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe.breweffects;

import java.text.DecimalFormat;
import java.util.List;
import mezz.jei.util.Translator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import soot.brewing.FluidModifier;
import soot.recipe.breweffects.IBrewEffect;
import soot.util.FluidUtil;

public class EffectMultiply
implements IBrewEffect {
    String modifier;
    float multiplier;
    float minLimit;
    float maxLimit;
    boolean hidden;

    public EffectMultiply(String modifier, float multiplier, float minLimit, float maxLimit, boolean hidden) {
        this.modifier = modifier;
        this.multiplier = multiplier;
        this.minLimit = minLimit;
        this.maxLimit = maxLimit;
        this.hidden = hidden;
    }

    public EffectMultiply(String modifier, float multiplier, boolean hidden) {
        this(modifier, multiplier, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, hidden);
    }

    private FluidModifier.EffectType getEffectType() {
        return FluidUtil.getEffectType(this.modifier);
    }

    @Override
    public void modify(FluidStack output, NBTTagCompound compound) {
        float value = this.getModifierOrDefault(this.modifier, compound, output);
        compound.func_74776_a(this.modifier, this.multiply(value));
    }

    private float multiply(float base) {
        if (base > this.minLimit && base < this.maxLimit) {
            return MathHelper.func_76131_a((float)(base * this.multiplier), (float)this.minLimit, (float)this.maxLimit);
        }
        return base;
    }

    @Override
    public void modifyTooltip(List<String> tooltip) {
        TextFormatting color;
        String key;
        if (this.hidden) {
            return;
        }
        FluidModifier.EffectType type = this.getEffectType();
        DecimalFormat format = new DecimalFormat("#.####");
        float amount = (this.multiplier - 1.0f) * 100.0f;
        if (amount > 0.0f) {
            key = "distilling.effect.add_percent";
            color = this.getTextColor(type, false);
        } else {
            key = "distilling.effect.sub_percent";
            color = this.getTextColor(type, true);
        }
        tooltip.add(tooltip.size() - 1, color + Translator.translateToLocalFormatted((String)key, (Object[])new Object[]{Translator.translateToLocal((String)("distilling.modifier." + this.modifier + ".name")), format.format(Math.abs(amount))}));
    }
}

