/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe.breweffects;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import soot.brewing.FluidModifier;
import soot.util.FluidUtil;

public interface IBrewEffect {
    public void modify(FluidStack var1, NBTTagCompound var2);

    public void modifyTooltip(List<String> var1);

    default public float getModifierOrDefault(String name, NBTTagCompound compound, FluidStack fluid) {
        return FluidUtil.getModifier(compound, fluid != null ? fluid.getFluid() : null, name);
    }

    default public TextFormatting getTextColor(FluidModifier.EffectType type, boolean invert) {
        switch (type) {
            case POSITIVE: {
                return invert ? TextFormatting.RED : TextFormatting.GREEN;
            }
            case NEGATIVE: {
                return invert ? TextFormatting.GREEN : TextFormatting.RED;
            }
            case NEUTRAL: {
                return TextFormatting.BLUE;
            }
        }
        return TextFormatting.GRAY;
    }
}

