/*
 * Decompiled with CFR 0.152.
 */
package soot.tile;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import soot.block.BlockAlchemyGlobe;
import soot.particle.ParticleUtilSoot;
import soot.upgrade.UpgradeAlchemyGlobe;
import teamroots.embers.api.alchemy.AspectList;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.TileEntityAlchemyPedestal;
import teamroots.embers.util.AlchemyUtil;
import teamroots.embers.util.Misc;

public class TileEntityAlchemyGlobe
extends TileEntity
implements ITickable {
    public static final int UPDATE_INTERVAL = 20;
    AspectList aspectList = new AspectList();
    boolean hasAspects = false;
    static Random random = new Random();
    UpgradeAlchemyGlobe.Status lastStatus;
    int lifeTime;
    int nextCheck;
    int preStartTick = 0;
    UpgradeAlchemyGlobe upgrade;
    private List<TileEntityAlchemyPedestal> pedestals = new ArrayList<TileEntityAlchemyPedestal>();

    public TileEntityAlchemyGlobe() {
        this.upgrade = new UpgradeAlchemyGlobe(this);
    }

    public boolean hasAspects() {
        return this.hasAspects;
    }

    public AspectList getAspects() {
        return this.aspectList;
    }

    public void consumeAsh() {
        List pedestals = AlchemyUtil.getNearbyPedestals((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        for (TileEntityAlchemyPedestal pedestal : pedestals) {
            pedestal.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockAlchemyGlobe) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockAlchemyGlobe.FACING);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && this.getFacing().func_176734_d() == facing || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && this.getFacing().func_176734_d() == facing ? this.upgrade : super.getCapability(capability, facing));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.upgrade.setStatus(UpgradeAlchemyGlobe.Status.values()[compound.func_74762_e("status")], compound.func_74762_e("statusTick"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("statusTick", this.upgrade.getStatusTick());
        compound.func_74768_a("status", this.upgrade.getStatus().ordinal());
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE((TileEntity)this);
    }

    public void func_73660_a() {
        ++this.lifeTime;
        UpgradeAlchemyGlobe.Status status = this.upgrade.getStatus();
        if (status != this.lastStatus) {
            this.func_70296_d();
        }
        if (this.lifeTime > this.nextCheck && status != UpgradeAlchemyGlobe.Status.Idle) {
            this.nextCheck = this.lifeTime + 20;
            this.pedestals = AlchemyUtil.getNearbyPedestals((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
            this.aspectList.reset();
            this.aspectList.collect(this.pedestals);
        }
        if (!this.field_145850_b.field_72995_K) {
            ++this.preStartTick;
            if (status == UpgradeAlchemyGlobe.Status.PreStarting && this.preStartTick > 60) {
                this.upgrade.setStatus(UpgradeAlchemyGlobe.Status.Idle);
            }
        }
        if (this.field_145850_b.field_72995_K) {
            double yaw;
            Color color = new Color(64, 32, 90);
            Color colorFlame = new Color(181, 90, 255);
            float ox = (float)this.field_174879_c.func_177958_n() + 0.5f;
            float oy = (float)this.field_174879_c.func_177956_o() + 0.5f;
            float oz = (float)this.field_174879_c.func_177952_p() + 0.5f;
            if (status == UpgradeAlchemyGlobe.Status.Starting || status == UpgradeAlchemyGlobe.Status.Success || status == UpgradeAlchemyGlobe.Status.Crafting) {
                float dz;
                float dy;
                float dx;
                double coeff = status == UpgradeAlchemyGlobe.Status.Starting ? (double)this.upgrade.getStatusTick() / 200.0 : (status == UpgradeAlchemyGlobe.Status.Crafting ? 0.5 : 1.0);
                for (int i = 0; i < 3; ++i) {
                    RayTraceResult raytraceresult;
                    double chance = random.nextDouble();
                    if (chance > (1.0 - coeff) * (1.0 - coeff)) continue;
                    yaw = (double)random.nextFloat() * Math.PI * 2.0;
                    double pitch = (double)random.nextFloat() * Math.PI * 2.0;
                    dx = (float)(Math.sin(yaw) * Math.cos(pitch));
                    dy = (float)Math.sin(pitch);
                    dz = (float)(Math.cos(yaw) * Math.cos(pitch));
                    double dist = 8.0;
                    double sx = (double)ox + (double)dx * 0.6;
                    double sy = (double)oy + (double)dy * 0.6;
                    double sz = (double)oz + (double)dz * 0.6;
                    if (this.field_145850_b.func_184143_b(new AxisAlignedBB(sx, sy, sz, sx, sy, sz)) || (raytraceresult = this.field_145850_b.func_147447_a(new Vec3d(sx, sy, sz), new Vec3d((double)ox + (double)dx * dist, (double)oy + (double)dy * dist, (double)oz + (double)dz * dist), true, true, false)) == null || raytraceresult.field_72307_f == null) continue;
                    ParticleUtilSoot.spawnLightning(this.field_145850_b, ox, oy, oz, raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c, 8, 0.3, color, MathHelper.func_151238_b((double)1.0, (double)1.5, (double)coeff), 5);
                }
                for (TileEntityAlchemyPedestal pedestal : this.pedestals) {
                    double chance;
                    if (pedestal.inventory.getStackInSlot(1).func_190926_b() || (chance = random.nextDouble()) > coeff * coeff) continue;
                    BlockPos pedestalPos = pedestal.func_174877_v();
                    float tx = (float)pedestalPos.func_177958_n() + 0.5f;
                    float ty = (float)pedestalPos.func_177956_o() + 0.9f;
                    float tz = (float)pedestalPos.func_177952_p() + 0.5f;
                    ParticleUtilSoot.spawnLightning(this.field_145850_b, ox, oy, oz, tx, ty, tz, 8, MathHelper.func_151238_b((double)0.4, (double)0.1, (double)coeff), color, MathHelper.func_151238_b((double)1.0, (double)2.0, (double)coeff), 5);
                }
                if (status == UpgradeAlchemyGlobe.Status.Starting) {
                    for (int i = 0; i < 5; ++i) {
                        float velocityFactor = random.nextFloat() * 1.0f + 0.5f;
                        double yaw2 = (double)random.nextFloat() * Math.PI * 2.0;
                        double pitch = (double)random.nextFloat() * Math.PI * 2.0;
                        float dist = 0.4f * (float)MathHelper.func_151238_b((double)4.0, (double)0.0, (double)coeff);
                        dx = (float)(Math.sin(yaw2) * Math.cos(pitch));
                        dy = (float)Math.sin(pitch);
                        dz = (float)(Math.cos(yaw2) * Math.cos(pitch));
                        float scale = 1.5f / velocityFactor * 0.5f;
                        int lifetime = (int)(50.0f / velocityFactor);
                        float velocity = velocityFactor * dist / (float)lifetime;
                        ParticleUtil.spawnParticleGlow((World)this.field_145850_b, (float)(ox + dx * dist), (float)(oy + dy * dist), (float)(oz + dz * dist), (float)(dx * -velocity), (float)(dy * -velocity), (float)(dz * -velocity), (float)colorFlame.getRed(), (float)colorFlame.getGreen(), (float)colorFlame.getBlue(), (float)((float)colorFlame.getAlpha() / 255.0f), (float)scale, (int)lifetime);
                    }
                }
            }
            double holeScale = 0.5 + Math.sin((double)this.lifeTime * Math.PI * 2.0 * 0.01) * 0.5;
            ParticleUtil.spawnParticleSmoke((World)this.field_145850_b, (float)ox, (float)oy, (float)oz, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)((float)MathHelper.func_151238_b((double)2.0, (double)6.0, (double)holeScale)), (int)(5 + random.nextInt(5)));
            if (status == UpgradeAlchemyGlobe.Status.Idle || status == UpgradeAlchemyGlobe.Status.Crafting || status == UpgradeAlchemyGlobe.Status.Success || status == UpgradeAlchemyGlobe.Status.PreStarting) {
                float flameSize = status == UpgradeAlchemyGlobe.Status.Idle || status == UpgradeAlchemyGlobe.Status.PreStarting ? 1.0f : 1.5f;
                for (int i = 0; i < 5; ++i) {
                    float velocityFactor = random.nextFloat() * 1.0f + 0.5f;
                    yaw = random.nextDouble() * Math.PI * 2.0;
                    double pitch = random.nextDouble() * Math.PI * 2.0;
                    float dist = 0.1f;
                    float dx = (float)(Math.sin(yaw) * Math.cos(pitch));
                    float dy = (float)Math.sin(pitch);
                    float dz = (float)(Math.cos(yaw) * Math.cos(pitch));
                    float scale = 1.5f / velocityFactor * 0.5f * flameSize;
                    int lifetime = (int)(50.0f / velocityFactor);
                    if (status != UpgradeAlchemyGlobe.Status.Idle) {
                        velocityFactor *= -1.0f;
                    }
                    ParticleUtil.spawnParticleGlow((World)this.field_145850_b, (float)(ox + dx * dist), (float)(oy - 0.1f + dy * dist), (float)(oz + dz * dist), (float)(dx * -0.01f * velocityFactor), (float)(dy * -0.01f * velocityFactor + 0.007f), (float)(dz * -0.01f * velocityFactor), (float)colorFlame.getRed(), (float)colorFlame.getGreen(), (float)colorFlame.getBlue(), (float)((float)colorFlame.getAlpha() / 255.0f), (float)scale, (int)lifetime);
                }
            }
        }
        this.lastStatus = status;
    }

    public void activate(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        UpgradeAlchemyGlobe.Status status = this.upgrade.getStatus();
        if (status == UpgradeAlchemyGlobe.Status.Idle) {
            this.upgrade.setStatus(UpgradeAlchemyGlobe.Status.PreStarting);
            this.preStartTick = 0;
        }
        if (status == UpgradeAlchemyGlobe.Status.Crafting || status == UpgradeAlchemyGlobe.Status.Success) {
            this.upgrade.setStatus(UpgradeAlchemyGlobe.Status.Idle);
        }
    }
}

