/*
 * Decompiled with CFR 0.152.
 */
package soot.tile;

import java.awt.Color;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import soot.block.BlockDecanter;
import soot.brewing.EssenceStack;
import soot.item.IEssenceContainer;
import soot.tile.TileEntityDecanterBase;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.IItemPipeConnectable;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;

public class TileEntityDecanterTop
extends TileEntityDecanterBase
implements ITileEntityBase,
ITickable,
IItemPipeConnectable {
    public ResourceLocation texture = new ResourceLocation("embers:textures/blocks/item_pipe_tex.png");
    public static final int CAPACITY = 8000;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityDecanterTop.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (!this.getStackInSlot(slot).func_190926_b()) {
                return stack;
            }
            Item item = stack.func_77973_b();
            if (item instanceof IEssenceContainer) {
                ItemStack filled = TileEntityDecanterTop.this.fillEssence(stack.func_77946_l(), (IEssenceContainer)item, simulate);
                ItemStack remainder = stack;
                if (!filled.func_190926_b() && super.insertItem(slot, filled, simulate).func_190926_b()) {
                    remainder = stack.func_77946_l();
                    remainder.func_190918_g(1);
                }
                return remainder;
            }
            return stack;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    EssenceStack currentEssence = EssenceStack.EMPTY;
    EssenceStack lastAdded = EssenceStack.EMPTY;
    private Random random = new Random();

    public int getCapacity() {
        return 8000;
    }

    @Override
    public boolean canAdd(EssenceStack stack) {
        return this.currentEssence.isEmpty() || Objects.equals(this.currentEssence.getEssence(), stack.getEssence());
    }

    @Override
    public EssenceStack add(EssenceStack stack) {
        EssenceStack remainder;
        if (this.currentEssence.isEmpty()) {
            this.currentEssence = stack.copy();
            remainder = EssenceStack.EMPTY;
        } else {
            remainder = Objects.equals(this.currentEssence.getEssence(), stack.getEssence()) ? this.currentEssence.merge(stack, this.getCapacity()) : stack;
        }
        if (remainder.getAmount() < stack.getAmount()) {
            this.lastAdded = stack.copy();
            this.lastAdded.setAmount(20);
            this.func_70296_d();
        }
        return remainder;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockDecanter) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockDecanter.FACING);
        }
        return null;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && !this.lastAdded.isEmpty()) {
            EnumFacing facing = this.getFacing();
            EnumFacing facingRight = facing.func_176746_e();
            Color color = this.lastAdded.getEssence().getFillColor();
            float xBase = (float)this.func_174877_v().func_177958_n() + 0.5f;
            float yBase = (float)this.func_174877_v().func_177956_o() + 0.5f;
            float zBase = (float)this.func_174877_v().func_177952_p() + 0.5f;
            float velocity = 0.03f;
            float xWide = 0.5f;
            float yWide = 0.1f;
            float xNarrow = 0.55f;
            float yNarrow = 0.275f;
            float x1 = xBase - xWide * (float)facing.func_82601_c();
            float y1 = yBase - yWide;
            float z1 = zBase - xWide * (float)facing.func_82599_e();
            float motionx1 = -velocity * 0.5f * (float)facing.func_82601_c() + this.random.nextFloat() * 0.02f - 0.01f;
            float motiony1 = velocity + this.random.nextFloat() * 0.02f - 0.01f;
            float motionz1 = -velocity * 0.5f * (float)facing.func_82599_e() + this.random.nextFloat() * 0.02f - 0.01f;
            float x2 = xBase + xNarrow * (float)facingRight.func_82601_c();
            float y2 = yBase - yNarrow;
            float z2 = zBase + xNarrow * (float)facingRight.func_82599_e();
            float motionx2 = velocity * (float)facingRight.func_82601_c() + this.random.nextFloat() * 0.02f - 0.01f;
            float motiony2 = velocity + this.random.nextFloat() * 0.02f - 0.01f;
            float motionz2 = velocity * (float)facingRight.func_82599_e() + this.random.nextFloat() * 0.02f - 0.01f;
            float x3 = xBase - xNarrow * (float)facingRight.func_82601_c();
            float y3 = yBase - yNarrow;
            float z3 = zBase - xNarrow * (float)facingRight.func_82599_e();
            float motionx3 = -velocity * (float)facingRight.func_82601_c() + this.random.nextFloat() * 0.02f - 0.01f;
            float motiony3 = velocity + this.random.nextFloat() * 0.02f - 0.01f;
            float motionz3 = -velocity * (float)facingRight.func_82599_e() + this.random.nextFloat() * 0.02f - 0.01f;
            ParticleUtil.spawnParticleVapor((World)this.func_145831_w(), (float)x1, (float)y1, (float)z1, (float)motionx1, (float)motiony1, (float)motionz1, (float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)1.0f, (float)1.0f, (float)2.0f, (int)24);
            ParticleUtil.spawnParticleVapor((World)this.func_145831_w(), (float)x2, (float)y2, (float)z2, (float)motionx2, (float)motiony2, (float)motionz2, (float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)1.0f, (float)1.0f, (float)2.0f, (int)24);
            ParticleUtil.spawnParticleVapor((World)this.func_145831_w(), (float)x3, (float)y3, (float)z3, (float)motionx3, (float)motiony3, (float)motionz3, (float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)1.0f, (float)1.0f, (float)2.0f, (int)24);
        }
        this.lastAdded.shrink(1);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("essence", (NBTBase)this.currentEssence.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("lastAdded", (NBTBase)this.lastAdded.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.currentEssence = new EssenceStack(tag.func_74775_l("essence"));
        this.lastAdded = new EssenceStack(tag.func_74775_l("lastAdded"));
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        Item item = heldItem.func_77973_b();
        if (item instanceof IEssenceContainer) {
            ItemStack filled = this.fillEssence(heldItem, (IEssenceContainer)item, false);
            if (!filled.func_190926_b()) {
                heldItem.func_190918_g(1);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v, filled));
                }
            }
            return true;
        }
        return false;
    }

    private ItemStack fillEssence(ItemStack stack, IEssenceContainer container, boolean simulate) {
        EssenceStack itemEssence = container.getEssence(stack);
        int capacity = container.getCapacity(stack);
        int toAdd = capacity - itemEssence.getAmount();
        EssenceStack essenceToFill = this.currentEssence;
        if (simulate) {
            essenceToFill = essenceToFill.copy();
        }
        if (essenceToFill.getAmount() >= toAdd && toAdd > 0) {
            EssenceStack addedEssence = essenceToFill.split(toAdd);
            return container.addEssence(stack, addedEssence);
        }
        return ItemStack.field_190927_a;
    }

    public EnumPipeConnection getConnection(EnumFacing facing) {
        if (facing.func_176740_k() != EnumFacing.Axis.Y) {
            return EnumPipeConnection.PIPE;
        }
        return EnumPipeConnection.BLOCK;
    }
}

