/*
 * Decompiled with CFR 0.152.
 */
package soot.tile;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import org.lwjgl.opengl.GL11;
import soot.brewing.EssenceStack;
import soot.tile.TileEntityDecanterTop;
import teamroots.embers.tileentity.IItemPipeConnectable;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.PipeRenderUtil;
import teamroots.embers.util.RenderUtil;

public class TileEntityDecanterTopRenderer
extends TileEntitySpecialRenderer<TileEntityDecanterTop> {
    public ResourceLocation texture = new ResourceLocation("embers:textures/blocks/item_pipe_tex.png");
    public static final ResourceLocation ESSENCE_STILL = new ResourceLocation("soot", "blocks/brew_essence");
    public static final ResourceLocation ESSENCE_FLOWING = new ResourceLocation("soot", "blocks/brew_essence_flowing");

    public void render(TileEntityDecanterTop tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a((TileEntity)tile, x, y, z, partialTicks, destroyStage, alpha);
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        EssenceStack stack = tile.currentEssence;
        if (!stack.isEmpty()) {
            double fillCoeff = (double)stack.getAmount() / (double)tile.getCapacity();
            double fill = MathHelper.func_151238_b((double)0.25, (double)1.0, (double)fillCoeff);
            Color color = stack.getEssence().getFillColor();
            TileEntityDecanterTopRenderer.renderEssenceCuboid(tile.func_174877_v(), 0.28125, 0.25, 0.28125, 0.71875, fill, 0.71875, color.getRGB());
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
        GlStateManager.func_179129_p();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!this.shouldRenderLip(tile, facing)) continue;
            PipeRenderUtil.addPipeLip((BufferBuilder)buffer, (double)x, (double)y, (double)z, (EnumFacing)facing);
        }
        tess.func_78381_a();
        GlStateManager.func_179089_o();
    }

    private EnumPipeConnection getPipeConnection(World world, BlockPos pos, EnumFacing facing) {
        TileEntity tile = world.func_175625_s(pos.func_177972_a(facing));
        if (tile instanceof IItemPipeConnectable) {
            return ((IItemPipeConnectable)tile).getConnection(facing.func_176734_d());
        }
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
            return EnumPipeConnection.BLOCK;
        }
        return EnumPipeConnection.NONE;
    }

    private boolean shouldRenderLip(TileEntityDecanterTop pipe, EnumFacing facing) {
        EnumPipeConnection connection = this.getPipeConnection(pipe.func_145831_w(), pipe.func_174877_v(), facing);
        return connection == EnumPipeConnection.PIPE || connection == EnumPipeConnection.BLOCK || connection == EnumPipeConnection.LEVER;
    }

    public static void renderEssenceCuboid(BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int luminosity = 15;
        int brightness = Minecraft.func_71410_x().field_71441_e.func_175626_b(pos, luminosity);
        TextureAtlasSprite still = Minecraft.func_71410_x().func_147117_R().getTextureExtry(ESSENCE_STILL.toString());
        TextureAtlasSprite flowing = Minecraft.func_71410_x().func_147117_R().getTextureExtry(ESSENCE_FLOWING.toString());
        RenderUtil.putTexturedQuad((BufferBuilder)renderer, (TextureAtlasSprite)still, (double)x1, (double)y1, (double)z1, (double)(x2 - x1), (double)(y2 - y1), (double)(z2 - z1), (EnumFacing)EnumFacing.DOWN, (int)color, (int)brightness, (boolean)false);
        RenderUtil.putTexturedQuad((BufferBuilder)renderer, (TextureAtlasSprite)flowing, (double)x1, (double)y1, (double)z1, (double)(x2 - x1), (double)(y2 - y1), (double)(z2 - z1), (EnumFacing)EnumFacing.NORTH, (int)color, (int)brightness, (boolean)true);
        RenderUtil.putTexturedQuad((BufferBuilder)renderer, (TextureAtlasSprite)flowing, (double)x1, (double)y1, (double)z1, (double)(x2 - x1), (double)(y2 - y1), (double)(z2 - z1), (EnumFacing)EnumFacing.EAST, (int)color, (int)brightness, (boolean)true);
        RenderUtil.putTexturedQuad((BufferBuilder)renderer, (TextureAtlasSprite)flowing, (double)x1, (double)y1, (double)z1, (double)(x2 - x1), (double)(y2 - y1), (double)(z2 - z1), (EnumFacing)EnumFacing.SOUTH, (int)color, (int)brightness, (boolean)true);
        RenderUtil.putTexturedQuad((BufferBuilder)renderer, (TextureAtlasSprite)flowing, (double)x1, (double)y1, (double)z1, (double)(x2 - x1), (double)(y2 - y1), (double)(z2 - z1), (EnumFacing)EnumFacing.WEST, (int)color, (int)brightness, (boolean)true);
        RenderUtil.putTexturedQuad((BufferBuilder)renderer, (TextureAtlasSprite)still, (double)x1, (double)y1, (double)z1, (double)(x2 - x1), (double)(y2 - y1), (double)(z2 - z1), (EnumFacing)EnumFacing.UP, (int)color, (int)brightness, (boolean)false);
        tessellator.func_78381_a();
    }
}

