/*
 * Decompiled with CFR 0.152.
 */
package soot.tile;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import soot.SoundEvents;
import soot.block.BlockStill;
import soot.recipe.CraftingRegistry;
import soot.recipe.RecipeStill;
import soot.tile.TileEntityStillTip;
import soot.util.FluidUtil;
import soot.util.HeatManager;
import teamroots.embers.Embers;
import teamroots.embers.api.event.MachineRecipeEvent;
import teamroots.embers.api.event.UpgradeEvent;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityStillBase
extends TileEntity
implements ITileEntityBase,
ITickable,
ISoundController {
    public static final int PROCESS_TIME = 40;
    public FluidTank tank = new FluidTank(5000);
    public List<IUpgradeProvider> upgrades;
    private int ticksExisted;
    double progress;
    public static final int SOUND_NONE = 0;
    public static final int SOUND_HOT = 1;
    public static final int SOUND_WORK_SLOW = 2;
    public static final int SOUND_WORK_FAST = 3;
    public static final int[] SOUND_IDS = new int[]{1, 2, 3};
    HashSet<Integer> soundsPlaying = new HashSet();
    int currentSound;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("tank", (NBTBase)tankTag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag.func_74775_l("tank"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean activate(World world, BlockPos blockPos, IBlockState iBlockState, EntityPlayer entityPlayer, EnumHand enumHand, EnumFacing enumFacing, float v, float v1, float v2) {
        return false;
    }

    public void breakBlock(World world, BlockPos blockPos, IBlockState iBlockState, EntityPlayer entityPlayer) {
        this.func_145843_s();
        world.func_175690_a(this.field_174879_c, null);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE((TileEntity)this);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing.func_176740_k() != EnumFacing.Axis.Y)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing.func_176740_k() != EnumFacing.Axis.Y)) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    private String getNameFromSign() {
        String name = null;
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            BlockPos signPos = this.field_174879_c.func_177972_a(dir);
            IBlockState signState = this.field_145850_b.func_180495_p(signPos);
            TileEntity tile = this.field_145850_b.func_175625_s(signPos);
            if (!(signState.func_177230_c() instanceof BlockWallSign) || !(tile instanceof TileEntitySign) || signState.func_177229_b((IProperty)BlockWallSign.field_176412_a) != dir) continue;
            TileEntitySign sign = (TileEntitySign)tile;
            name = "";
            for (ITextComponent text : sign.field_145915_a) {
                String line = text.func_150260_c().trim();
                name = line.endsWith("-") ? name + line.substring(0, line.length() - 2) : name + line + " ";
            }
            name = name.trim();
            break;
        }
        return name;
    }

    public TileEntityStillTip getTip() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(state.func_177230_c() instanceof BlockStill)) {
            return null;
        }
        BlockStill block = (BlockStill)state.func_177230_c();
        BlockPos tipPos = block.getTip(this.field_174879_c, state);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(tipPos);
        if (tileEntity instanceof TileEntityStillTip) {
            return (TileEntityStillTip)tileEntity;
        }
        return null;
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (this.func_145831_w().field_72995_K) {
            this.handleSound();
        }
        double heat = HeatManager.getHeat(this.field_145850_b, this.field_174879_c.func_177977_b());
        TileEntityStillTip tip = this.getTip();
        if (tip != null) {
            this.upgrades = UpgradeUtil.getUpgrades((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing[])EnumFacing.field_176754_o);
            UpgradeUtil.verifyUpgrades((TileEntity)this, this.upgrades);
            double speedMod = UpgradeUtil.getTotalSpeedModifier((TileEntity)this, this.upgrades);
            double heatSpeed = 1.0;
            if (heat > 200.0) {
                heatSpeed = 1.0 + (heat - 200.0) / 100.0;
            }
            this.progress += speedMod * heatSpeed;
            int cookTime = (int)Math.ceil(MathHelper.func_151238_b((double)1.0, (double)40.0, (double)(1.0 - heat / 200.0)) * (1.0 / speedMod));
            if (this.progress >= (double)cookTime) {
                FluidTank output = tip.tank;
                FluidStack inputStack = this.tank.getFluid();
                RecipeStill recipe = this.getRecipe(inputStack, tip.getCurrentCatalyst());
                if (recipe == null) {
                    this.setIdleSound(heat);
                    this.progress = 0.0;
                }
                while (recipe != null && this.progress >= (double)cookTime && heat > 0.0) {
                    boolean cancel = UpgradeUtil.doWork((TileEntity)this, this.upgrades);
                    if (!cancel) {
                        this.currentSound = cookTime > 1 ? 2 : 3;
                        inputStack = this.tank.drain(recipe.getInputConsumed(), false);
                        FluidStack outputStack = UpgradeUtil.transformOutput((TileEntity)this, (FluidStack)recipe.getOutput(this, inputStack), this.upgrades);
                        String brewName = this.getNameFromSign();
                        if (brewName != null) {
                            NBTTagCompound compound = FluidUtil.createModifiers(outputStack);
                            if (!brewName.isEmpty()) {
                                compound.func_74778_a("custom_name", brewName);
                            } else {
                                compound.func_82580_o("custom_name");
                            }
                        }
                        if (output.fill(outputStack, false) == outputStack.amount) {
                            UpgradeUtil.throwEvent((TileEntity)this, (UpgradeEvent)new MachineRecipeEvent.Success((TileEntity)this, (Object)recipe), this.upgrades);
                            if (inputStack != null) {
                                this.tank.drain(inputStack.amount, true);
                            }
                            output.fill(outputStack, true);
                            tip.depleteCatalyst(recipe.catalystConsumed);
                            this.func_70296_d();
                            tip.func_70296_d();
                        }
                    }
                    this.progress = this.field_145850_b.field_72995_K ? 0.0 : (this.progress -= (double)cookTime);
                    inputStack = this.tank.getFluid();
                    if (recipe.matches(this, inputStack, tip.getCurrentCatalyst())) continue;
                    recipe = null;
                }
            }
        } else {
            this.setIdleSound(heat);
        }
    }

    private RecipeStill getRecipe(FluidStack fluid, ItemStack catalyst) {
        RecipeStill recipe = CraftingRegistry.getStillRecipe(this, fluid, catalyst);
        MachineRecipeEvent event = new MachineRecipeEvent((TileEntity)this, (Object)recipe);
        UpgradeUtil.throwEvent((TileEntity)this, (UpgradeEvent)event, this.upgrades);
        return (RecipeStill)event.getRecipe();
    }

    public void setIdleSound(double heat) {
        this.currentSound = 0;
        if (heat > 0.0) {
            this.currentSound = 1;
        }
    }

    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound((TileEntity)this, 1, SoundEvents.STILL_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                break;
            }
            case 2: {
                Embers.proxy.playMachineSound((TileEntity)this, 2, SoundEvents.STILL_SLOW, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                break;
            }
            case 3: {
                Embers.proxy.playMachineSound((TileEntity)this, 3, SoundEvents.STILL_FAST, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    public boolean shouldPlaySound(int id) {
        return id == this.currentSound;
    }
}

