/*
 * Decompiled with CFR 0.152.
 */
package soot.tile;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import soot.recipe.CraftingRegistry;
import teamroots.embers.tileentity.IItemPipeConnectable;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;

public class TileEntityStillTip
extends TileEntity
implements ITileEntityBase,
ITickable,
IItemPipeConnectable {
    public FluidTank tank = new FluidTank(1000);
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityStillTip.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlotLimit(int slot) {
            return 4;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack current = this.getStackInSlot(slot);
            if (TileEntityStillTip.this.catalystAmount > 0) {
                amount = Math.min(amount, current.func_190916_E() - 1);
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    public int catalystAmount = 0;
    private Random random = new Random();
    public boolean connectUp;
    public boolean connectNorth;
    public boolean connectSouth;
    public boolean connectEast;
    public boolean connectWest;

    public void updateConnections() {
        this.connectUp = this.canConnectTo(EnumFacing.UP);
        this.connectNorth = this.canConnectTo(EnumFacing.NORTH);
        this.connectSouth = this.canConnectTo(EnumFacing.SOUTH);
        this.connectEast = this.canConnectTo(EnumFacing.EAST);
        this.connectWest = this.canConnectTo(EnumFacing.WEST);
        this.func_70296_d();
    }

    public boolean canConnectTo(EnumFacing facing) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        return tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("up", this.connectUp);
        tag.func_74757_a("north", this.connectNorth);
        tag.func_74757_a("south", this.connectSouth);
        tag.func_74757_a("east", this.connectEast);
        tag.func_74757_a("west", this.connectWest);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.connectUp = tag.func_74767_n("up");
        this.connectNorth = tag.func_74767_n("north");
        this.connectSouth = tag.func_74767_n("south");
        this.connectEast = tag.func_74767_n("east");
        this.connectWest = tag.func_74767_n("west");
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
    }

    public void depleteCatalyst(int amount) {
        if (this.catalystAmount <= 0) {
            this.catalystAmount = this.getCatalystAmount(this.getCurrentCatalyst());
        }
        this.catalystAmount = Math.max(this.catalystAmount - amount, 0);
        if (this.catalystAmount <= 0) {
            this.depleteItem(0, this.random);
        }
    }

    public void depleteItem(int slot, Random random) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        if (stack.func_77984_f()) {
            stack.func_96631_a(1, random, null);
        } else {
            stack.func_190918_g(1);
        }
        this.inventory.setStackInSlot(slot, stack);
    }

    public ItemStack getCurrentCatalyst() {
        return this.inventory.getStackInSlot(0);
    }

    public int getCatalystAmount(ItemStack stack) {
        return CraftingRegistry.getStillCatalyst(stack);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean activate(World world, BlockPos blockPos, IBlockState iBlockState, EntityPlayer entityPlayer, EnumHand enumHand, EnumFacing enumFacing, float v, float v1, float v2) {
        return false;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld((World)this.func_145831_w(), (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE((TileEntity)this);
    }

    public void func_73660_a() {
        IFluidHandler fluidTank;
        int amount;
        TileEntity tileEntity;
        if (this.tank.getFluidAmount() > 0 && (tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP) && (amount = (fluidTank = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)).fill(this.tank.getFluid(), true)) > 0) {
            this.tank.drain(amount, true);
            this.func_70296_d();
        }
    }

    public EnumPipeConnection getConnection(EnumFacing enumFacing) {
        return EnumPipeConnection.PIPE;
    }
}

