/*
 * Decompiled with CFR 0.152.
 */
package soot.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import soot.tile.TileEntityStillTip;
import teamroots.embers.tileentity.IItemPipeConnectable;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.PipeRenderUtil;

public class TileEntityStillTipRenderer
extends TileEntitySpecialRenderer<TileEntityStillTip> {
    public ResourceLocation texture = new ResourceLocation("embers:textures/blocks/item_pipe_tex.png");

    public void render(TileEntityStillTip tile, double x, double y, double z, float partialTicks, int destroyStage, float tileAlpha) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        GlStateManager.func_179129_p();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (this.shouldRenderPipe(tile, facing)) {
                PipeRenderUtil.addPipe((BufferBuilder)buffer, (double)x, (double)y, (double)z, (EnumFacing)facing);
            }
            if (!this.shouldRenderLip(tile, facing)) continue;
            PipeRenderUtil.addPipeLip((BufferBuilder)buffer, (double)x, (double)y, (double)z, (EnumFacing)facing);
        }
        tess.func_78381_a();
        GlStateManager.func_179089_o();
    }

    private EnumPipeConnection getPipeConnection(World world, BlockPos pos, EnumFacing facing) {
        TileEntity tile = world.func_175625_s(pos.func_177972_a(facing));
        if (tile instanceof IItemPipeConnectable) {
            return ((IItemPipeConnectable)tile).getConnection(facing.func_176734_d());
        }
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
            return EnumPipeConnection.BLOCK;
        }
        return EnumPipeConnection.NONE;
    }

    private boolean shouldRenderLip(TileEntityStillTip pipe, EnumFacing facing) {
        EnumPipeConnection connection = this.getPipeConnection(pipe.func_145831_w(), pipe.func_174877_v(), facing);
        return connection == EnumPipeConnection.BLOCK || connection == EnumPipeConnection.LEVER;
    }

    private boolean shouldRenderPipe(TileEntityStillTip pipe, EnumFacing facing) {
        EnumPipeConnection connection = this.getPipeConnection(pipe.func_145831_w(), pipe.func_174877_v(), facing);
        return connection == EnumPipeConnection.PIPE || this.shouldRenderLip(pipe, facing);
    }
}

