/*
 * Decompiled with CFR 0.152.
 */
package soot.upgrade;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import soot.brewing.EssenceStack;
import soot.recipe.RecipeStill;
import soot.tile.TileEntityDecanterBottom;
import soot.tile.TileEntityStillBase;
import teamroots.embers.Embers;
import teamroots.embers.api.event.DialInformationEvent;
import teamroots.embers.api.event.MachineRecipeEvent;
import teamroots.embers.api.event.UpgradeEvent;
import teamroots.embers.util.DefaultUpgradeProvider;

public class UpgradeDecanter
extends DefaultUpgradeProvider {
    private static ThreadLocal<List<EssenceStack>> currentEssence = new ThreadLocal();
    RecipeStill currentRecipe;

    public UpgradeDecanter(TileEntity tile) {
        super("decanter", tile);
    }

    public void throwEvent(TileEntity tile, UpgradeEvent event) {
        Object recipe;
        DialInformationEvent dialEvent;
        if (event instanceof DialInformationEvent && "alchemy".equals((dialEvent = (DialInformationEvent)event).getDialType())) {
            dialEvent.getInformation().add(Embers.proxy.formatLocalize("embers.tooltip.upgrade.decanter", new Object[0]));
        }
        if (event instanceof MachineRecipeEvent.Success) {
            if (this.tile instanceof TileEntityDecanterBottom) {
                List<EssenceStack> essence = currentEssence.get();
                if (essence == null) {
                    if (tile instanceof TileEntityStillBase) {
                        TileEntityStillBase still = (TileEntityStillBase)tile;
                        FluidStack input = still.tank.drain(this.currentRecipe.getInputConsumed(), false);
                        ItemStack catalyst = still.getTip().getCurrentCatalyst();
                        essence = new ArrayList<EssenceStack>(this.currentRecipe.getEssenceOutput(still, input, catalyst));
                    }
                    currentEssence.set(essence);
                }
                Iterator<EssenceStack> iterator = essence.iterator();
                while (iterator.hasNext()) {
                    EssenceStack myEssence = iterator.next();
                    if (!((TileEntityDecanterBottom)this.tile).canAdd(myEssence)) continue;
                    ((TileEntityDecanterBottom)this.tile).add(myEssence);
                    iterator.remove();
                    break;
                }
            }
        } else if (event instanceof MachineRecipeEvent && (recipe = ((MachineRecipeEvent)event).getRecipe()) instanceof RecipeStill) {
            this.currentRecipe = (RecipeStill)recipe;
            currentEssence.remove();
        }
    }
}

