/*
 * Decompiled with CFR 0.152.
 */
package soot.upgrade;

import java.awt.Color;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import soot.util.MiscUtil;
import teamroots.embers.api.event.HeatCoilVisualEvent;
import teamroots.embers.api.event.UpgradeEvent;
import teamroots.embers.tileentity.TileEntityHeatCoil;
import teamroots.embers.util.DefaultUpgradeProvider;

public class UpgradeInsulation
extends DefaultUpgradeProvider {
    public UpgradeInsulation(TileEntity tile) {
        super("insulation", tile);
    }

    public int getLimit(TileEntity tile) {
        if (tile instanceof TileEntityHeatCoil) {
            return 5;
        }
        return 0;
    }

    public double getOtherParameter(TileEntity tile, String type, double value) {
        if (type.equals("max_heat")) {
            return value + 75.0;
        }
        if (type.equals("cooling_speed")) {
            return value * 0.7;
        }
        return value;
    }

    public double transformEmberConsumption(TileEntity tile, double ember) {
        return ember * 0.8;
    }

    public void throwEvent(TileEntity tile, UpgradeEvent event) {
        if (event instanceof HeatCoilVisualEvent && tile instanceof TileEntityHeatCoil) {
            HeatCoilVisualEvent visualEvent = (HeatCoilVisualEvent)event;
            double heat = ((TileEntityHeatCoil)tile).heat;
            double overheat = heat - 280.0;
            visualEvent.setColor(MiscUtil.lerpColor(visualEvent.getColor(), new Color(192, 255, 128), MathHelper.func_151237_a((double)(overheat / 200.0), (double)0.0, (double)1.0)));
            visualEvent.setVerticalSpeed((float)MathHelper.func_151238_b((double)visualEvent.getVerticalSpeed(), (double)Math.max((double)visualEvent.getVerticalSpeed(), 0.03), (double)(overheat / 200.0)));
        }
    }
}

