/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import com.google.common.collect.HashMultimap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import soot.util.IHeatProvider;

public class HeatManager {
    static HashMultimap<Block, IHeatProvider> REGISTRY = HashMultimap.create();

    public static void register(Block block, IHeatProvider provider) {
        REGISTRY.put((Object)block, (Object)provider);
    }

    public static void register(Block block, int heat) {
        REGISTRY.put((Object)block, (Object)new BlockHeatProvider(heat));
    }

    public static void register(IBlockState state, int heat) {
        REGISTRY.put((Object)state.func_177230_c(), (Object)new BlockStateHeatProvider(state, heat));
    }

    public static double getHeat(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Set heatProviders = REGISTRY.get((Object)state.func_177230_c());
        for (IHeatProvider heatProvider : heatProviders) {
            double heat = heatProvider.provideHeat(world, pos, state);
            if (!(heat >= 0.0)) continue;
            return heat;
        }
        return -1.0;
    }

    public static class BlockHeatProvider
    implements IHeatProvider {
        int heat;

        public BlockHeatProvider(int heat) {
            this.heat = heat;
        }

        @Override
        public double provideHeat(World world, BlockPos pos, IBlockState state) {
            return this.heat;
        }
    }

    public static class BlockStateHeatProvider
    implements IHeatProvider {
        IBlockState state;
        int heat;

        public BlockStateHeatProvider(IBlockState state, int heat) {
            this.state = state;
            this.heat = heat;
        }

        @Override
        public double provideHeat(World world, BlockPos pos, IBlockState state) {
            return this.state == state ? (double)this.heat : -1.0;
        }
    }
}

