/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api;

import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponProperty;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.oredict.OreDictionary;

public class ToolMaterialEx {
    public static final ToolMaterialEx WOOD = new ToolMaterialEx("wood", Item.ToolMaterial.WOOD, "plankWood");
    public static final ToolMaterialEx STONE = new ToolMaterialEx("stone", Item.ToolMaterial.STONE, "cobblestone");
    public static final ToolMaterialEx IRON = new ToolMaterialEx("iron", Item.ToolMaterial.IRON, "ingotIron");
    public static final ToolMaterialEx GOLD = new ToolMaterialEx("gold", Item.ToolMaterial.GOLD, "ingotGold");
    public static final ToolMaterialEx DIAMOND = new ToolMaterialEx("diamond", Item.ToolMaterial.DIAMOND, "gemDiamond");
    public static final ToolMaterialEx LEATHER = new ToolMaterialEx("leather", EnumHelper.addToolMaterial((String)"sw_leather", (int)0, (int)128, (float)2.0f, (float)0.0f, (int)5).setRepairItem(new ItemStack(Items.field_151116_aA)), "leather");
    protected Item.ToolMaterial material;
    protected String unlocName;
    protected String modId = "spartanweaponry";
    protected String repairOreDict;
    protected float baseDamage;
    protected int colourPrimary = 0x7F7F7F;
    protected int colourSecondary = 0xFFFFFF;
    protected List<WeaponProperty> properties = new ArrayList<WeaponProperty>();

    public ToolMaterialEx(String unlocalizedName, String repairMaterialOreDict, int primaryColour, int secondaryColour, int harvestLevel, int maxUses, float efficiency, float baseDamage, int enchantability) {
        this(unlocalizedName, repairMaterialOreDict, "spartanweaponry", primaryColour, secondaryColour, harvestLevel, maxUses, efficiency, baseDamage, enchantability);
    }

    public ToolMaterialEx(String unlocalizedName, String repairMaterialOreDict, String externalModId, int primaryColour, int secondaryColour, int harvestLevel, int maxUses, float efficiency, float baseDamage, int enchantability) {
        this.unlocName = unlocalizedName;
        this.repairOreDict = repairMaterialOreDict;
        this.colourPrimary = primaryColour;
        this.colourSecondary = secondaryColour;
        this.modId = externalModId;
        this.baseDamage = baseDamage;
        this.material = EnumHelper.addToolMaterial((String)(externalModId + ":" + unlocalizedName), (int)harvestLevel, (int)maxUses, (float)efficiency, (float)baseDamage, (int)enchantability);
    }

    public ToolMaterialEx(String unlocalizedName, String repairMaterialOreDict, String externalModId, int primaryColour, int secondaryColour, int harvestLevel, int maxUses, float efficiency, float baseDamage, int enchantability, WeaponProperty ... weaponProperties) {
        this(unlocalizedName, repairMaterialOreDict, externalModId, primaryColour, secondaryColour, harvestLevel, maxUses, efficiency, baseDamage, enchantability);
        for (WeaponProperty property : weaponProperties) {
            this.properties.add(property);
        }
    }

    public ToolMaterialEx(String unlocalizedName, Item.ToolMaterial toolMaterial, String repairMaterialOreDict, String externalModId, float baseDamage, WeaponProperty ... weaponProperties) {
        this(unlocalizedName, toolMaterial, repairMaterialOreDict, externalModId, baseDamage);
        for (WeaponProperty property : weaponProperties) {
            this.properties.add(property);
        }
    }

    public ToolMaterialEx(String unlocalizedName, Item.ToolMaterial toolMaterial, String repairMaterialOreDict, String externalModId, float baseDamage) {
        this(unlocalizedName, toolMaterial, repairMaterialOreDict, externalModId);
        this.baseDamage = baseDamage;
    }

    public ToolMaterialEx(String unlocalizedName, Item.ToolMaterial toolMaterial, String repairMaterialOreDict, String externalModId) {
        this(unlocalizedName, toolMaterial, repairMaterialOreDict);
        this.modId = externalModId;
    }

    protected ToolMaterialEx(String unlocalizedName, Item.ToolMaterial toolMaterialBase, String repairMaterialOreDict) {
        this.unlocName = unlocalizedName;
        this.material = toolMaterialBase;
        this.repairOreDict = repairMaterialOreDict;
        this.baseDamage = toolMaterialBase.func_78000_c();
    }

    public Item.ToolMaterial getMaterial() {
        return this.material;
    }

    public String getUnlocName() {
        return this.unlocName;
    }

    public String getFullUnlocName() {
        return String.format("material.%s:%s", this.modId, this.unlocName);
    }

    public String getOreDictForRepairMaterial() {
        return this.repairOreDict;
    }

    public boolean doesOreDictMatch(ItemStack stack) {
        if (!OreDictionary.doesOreNameExist((String)this.repairOreDict)) {
            return false;
        }
        NonNullList ores = OreDictionary.getOres((String)this.repairOreDict, (boolean)false);
        for (ItemStack ore : ores) {
            if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public int getPrimaryColour() {
        return this.colourPrimary;
    }

    public int getSecondaryColour() {
        return this.colourSecondary;
    }

    public String getModId() {
        return this.modId;
    }

    public int getMaxUses() {
        return this.material.func_77997_a();
    }

    public float getEfficiency() {
        return this.material.func_77998_b();
    }

    public float getAttackDamage() {
        return this.baseDamage;
    }

    public int getHarvestLevel() {
        return this.material.func_77996_d();
    }

    public int getEnchantability() {
        return this.material.func_77995_e();
    }

    public boolean hasAnyWeaponProperty() {
        return !this.properties.isEmpty();
    }

    public boolean hasWeaponProperty(WeaponProperty prop) {
        return this.properties.contains(prop);
    }

    public WeaponProperty getFirstWeaponPropertyWithType(String type) {
        for (WeaponProperty property : this.properties) {
            if (property.getType() != type) continue;
            return property;
        }
        return null;
    }

    public List<WeaponProperty> getAllWeaponPropertiesWithType(String type) {
        ArrayList<WeaponProperty> result = new ArrayList<WeaponProperty>();
        for (WeaponProperty property : this.properties) {
            if (property.getType() != type) continue;
            result.add(property);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List<WeaponProperty> getAllWeaponProperties() {
        return this.properties;
    }
}

